/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.runtime.core.functions.runtime;

import java.io.Serializable;
import org.mule.weave.v2.model.values.ArrayValue;
import org.mule.weave.v2.model.values.ArrayValue$;
import org.mule.weave.v2.model.values.BooleanValue$;
import org.mule.weave.v2.model.values.NullValue$;
import org.mule.weave.v2.model.values.NumberValue$;
import org.mule.weave.v2.model.values.ObjectValue;
import org.mule.weave.v2.model.values.ObjectValueBuilder;
import org.mule.weave.v2.model.values.StringValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.math.Number$;
import org.mule.weave.v2.module.DataFormat;
import org.mule.weave.v2.module.option.ModuleOption;
import org.mule.weave.v2.parser.module.MimeType;
import scala.Function1;
import scala.None$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DataFormatDescriptorConverter$ {
    public static DataFormatDescriptorConverter$ MODULE$;
    private final String NAME_KEY;
    private final String BINARY_KEY;
    private final String DEFAULT_ENCODING_KEY;
    private final String EXTENSIONS_KEY;
    private final String DEFAULT_MIME_TYPE_KEY;
    private final String ACCEPTED_MIME_TYPES_KEY;
    private final String READER_PROPERTIES_KEY;
    private final String WRITER_PROPERTIES_KEY;
    private final String OPTIONAL_KEY;
    private final String DEFAULT_VALUE_KEY;
    private final String DESCRIPTION_KEY;
    private final String POSSIBLE_VALUES_KEY;

    static {
        new DataFormatDescriptorConverter$();
    }

    private String NAME_KEY() {
        return this.NAME_KEY;
    }

    private String BINARY_KEY() {
        return this.BINARY_KEY;
    }

    private String DEFAULT_ENCODING_KEY() {
        return this.DEFAULT_ENCODING_KEY;
    }

    private String EXTENSIONS_KEY() {
        return this.EXTENSIONS_KEY;
    }

    private String DEFAULT_MIME_TYPE_KEY() {
        return this.DEFAULT_MIME_TYPE_KEY;
    }

    private String ACCEPTED_MIME_TYPES_KEY() {
        return this.ACCEPTED_MIME_TYPES_KEY;
    }

    private String READER_PROPERTIES_KEY() {
        return this.READER_PROPERTIES_KEY;
    }

    private String WRITER_PROPERTIES_KEY() {
        return this.WRITER_PROPERTIES_KEY;
    }

    private String OPTIONAL_KEY() {
        return this.OPTIONAL_KEY;
    }

    private String DEFAULT_VALUE_KEY() {
        return this.DEFAULT_VALUE_KEY;
    }

    private String DESCRIPTION_KEY() {
        return this.DESCRIPTION_KEY;
    }

    private String POSSIBLE_VALUES_KEY() {
        return this.POSSIBLE_VALUES_KEY;
    }

    public ObjectValue toObjectValue(DataFormat<?, ?> df) {
        ObjectValueBuilder dataFormatDescriptor = new ObjectValueBuilder();
        dataFormatDescriptor.addPair(this.NAME_KEY(), df.name());
        dataFormatDescriptor.addPair(this.BINARY_KEY(), df.binaryFormat());
        Object object = df.defaultCharset().isDefined() ? dataFormatDescriptor.addPair(this.DEFAULT_ENCODING_KEY(), df.defaultCharset().get().name()) : BoxedUnit.UNIT;
        dataFormatDescriptor.addPair(this.EXTENSIONS_KEY(), df.fileExtensions());
        dataFormatDescriptor.addPair(this.DEFAULT_MIME_TYPE_KEY(), df.defaultMimeType().toString());
        dataFormatDescriptor.addPair(this.ACCEPTED_MIME_TYPES_KEY(), df.acceptedMimeTypes().map((Function1<MimeType, String> & Serializable & scala.Serializable)x$1 -> x$1.toString(), Seq$.MODULE$.canBuildFrom()));
        dataFormatDescriptor.addPair(this.READER_PROPERTIES_KEY(), this.buildDataFormatProperties(df.readerOptions()));
        dataFormatDescriptor.addPair(this.WRITER_PROPERTIES_KEY(), this.buildDataFormatProperties(df.writerOptions()));
        return dataFormatDescriptor.build();
    }

    private ArrayValue buildDataFormatProperties(Map<String, ModuleOption> options) {
        Seq<Value<?>> optionsValue = ((TraversableOnce)options.filterNot((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(DataFormatDescriptorConverter$.$anonfun$buildDataFormatProperties$1(x$2))).map((Function1<Tuple2, ObjectValue> & Serializable & scala.Serializable)option -> {
            ModuleOption optionValue = (ModuleOption)option._2();
            ObjectValueBuilder dataFormatDescriptor = new ObjectValueBuilder();
            dataFormatDescriptor.addPair(MODULE$.NAME_KEY(), (String)option._1());
            dataFormatDescriptor.addPair(MODULE$.OPTIONAL_KEY(), !optionValue.required());
            dataFormatDescriptor.addPair(MODULE$.DEFAULT_VALUE_KEY(), MODULE$.asValue(optionValue.defaultValue()));
            dataFormatDescriptor.addPair(MODULE$.DESCRIPTION_KEY(), optionValue.description());
            dataFormatDescriptor.addPair(MODULE$.POSSIBLE_VALUES_KEY(), ArrayValue$.MODULE$.apply(((SetLike)optionValue.possibleValues().map((Function1<Object, Value> & Serializable & scala.Serializable)v -> MODULE$.asValue(v), Set$.MODULE$.canBuildFrom())).toSeq()));
            return dataFormatDescriptor.build();
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        return ArrayValue$.MODULE$.apply(optionsValue);
    }

    private Value<?> asValue(Object v) {
        while (true) {
            Object object;
            if ((object = v) instanceof String) {
                String string = (String)object;
                return StringValue$.MODULE$.apply(string);
            }
            if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean(object);
                return BooleanValue$.MODULE$.apply(bl, BooleanValue$.MODULE$.apply$default$2(), BooleanValue$.MODULE$.apply$default$3());
            }
            if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt(object);
                return NumberValue$.MODULE$.apply(n);
            }
            if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong(object);
                return NumberValue$.MODULE$.apply(l);
            }
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble(object);
                return NumberValue$.MODULE$.apply(Number$.MODULE$.apply(d));
            }
            if (object == null) {
                return NullValue$.MODULE$;
            }
            if (None$.MODULE$.equals(object)) {
                return StringValue$.MODULE$.apply("None");
            }
            if (!(object instanceof Some)) break;
            Some some = (Some)object;
            Object s2 = some.value();
            v = s2;
        }
        return StringValue$.MODULE$.apply(String.valueOf(v));
    }

    public static final /* synthetic */ boolean $anonfun$buildDataFormatProperties$1(Tuple2 x$2) {
        return ((ModuleOption)x$2._2()).internal();
    }

    private DataFormatDescriptorConverter$() {
        MODULE$ = this;
        this.NAME_KEY = "name";
        this.BINARY_KEY = "binary";
        this.DEFAULT_ENCODING_KEY = "defaultEncoding";
        this.EXTENSIONS_KEY = "extensions";
        this.DEFAULT_MIME_TYPE_KEY = "defaultMimeType";
        this.ACCEPTED_MIME_TYPES_KEY = "acceptedMimeTypes";
        this.READER_PROPERTIES_KEY = "readerProperties";
        this.WRITER_PROPERTIES_KEY = "writerProperties";
        this.OPTIONAL_KEY = "optional";
        this.DEFAULT_VALUE_KEY = "defaultValue";
        this.DESCRIPTION_KEY = "description";
        this.POSSIBLE_VALUES_KEY = "possibleValues";
    }
}

