%dw 2.0
ns xsi http://www.w3.org/2001/XMLSchema-instance
ns ns1 http://www.mulesoft.org/schema/mule/core
ns doc http://www.mulesoft.org/schema/mule/documentation
ns http http://www.mulesoft.org/schema/mule/http
ns os http://www.mulesoft.org/schema/mule/os
ns a2a http://www.mulesoft.org/schema/mule/a2a
ns ee http://www.mulesoft.org/schema/mule/ee/core
output xml
---
{
    ns1#mule @(xsi#schemaLocation: "http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd 
                                    http://www.mulesoft.org/schema/mule/http http://www.mulesoft.org/schema/mule/http/current/mule-http.xsd 
                                    http://www.mulesoft.org/schema/mule/a2a http://www.mulesoft.org/schema/mule/a2a/current/mule-a2a.xsd
                                    http://www.mulesoft.org/schema/mule/ee/core http://www.mulesoft.org/schema/mule/ee/core/current/mule-ee.xsd 
                                    http://www.mulesoft.org/schema/mule/slack http://www.mulesoft.org/schema/mule/slack/current/mule-slack.xsd 
                                    http://www.mulesoft.org/schema/mule/os http://www.mulesoft.org/schema/mule/os/current/mule-os.xsd"):         
        {
            http#"request-config" @(name: "SlackAPI", doc#name: "HTTP Request configuration", doc#id: "ee1c26d6-5d61-47fd-b67f-afc1f4aa59a1"): {
                    http#"request-connection" @(host: "api.slack.com", protocol: "HTTPS"): null
                },

            os#"object-store" @(name: "Object_store", doc#name: "Object store", doc#id: "78036ee5-b6a4-4373-9e17-a95e1731e5ac"): null,
                
            ns1#flow @(name: "keynote-agentprotection-demoFlow", doc#id: "d4acd4f2-5f5b-4eac-bad6-f7751707e4b7"): {
                    http#listener @(doc#name: "/slack/exchange-rate", doc#id: "f1949619-75d0-4056-97a7-c63d8841be1b", "config-ref": "HTTP_Listener_config", path: "/exchange-rate"): null,
                    ns1#choice @(doc#name: "Choice", doc#id: "55c7e3e8-4422-401d-83a2-d44702cba3b6"): {
                            ns1#when @(expression: "#[payload.'type' == \"event_callback\" and payload.event.text != null and payload.event.app_id == null and payload.event.subtype == null]"): {
                                    os#contains @(doc#name: "Contains", doc#id: "b099e000-9fe7-4dd2-a97b-42438c814aac", key: "#[payload.event.client_msg_id]", objectStore: "Object_store", target: "already_processed"): null,
                                    ns1#choice @(doc#name: "Choice", doc#id: "de13f55f-a1e4-4558-bbee-740141db6195"): {
                                            ns1#when @(expression: "#[not vars.already_processed]"):                   
                                                {
                                                    os#store @(doc#name: "Store", doc#id: "403be5a1-6903-4e46-ab20-5f6994437f2a", key: "#[payload.event.client_msg_id]", failOnNullValue: "false", objectStore: "Object_store"): {
                                                            os#value: "#[payload.event.client_msg_id]" as String { cdata: true }
                                                        },                                                    
                                                    ns1#"set-variable" @(value: "#[payload.event]", doc#name: "SlackEvent", doc#id: "5f69da51-dbb7-4f20-964e-791d387fc51c", variableName: "slack_event"): null,
                                                    ee#transform @(doc#name: "Gather Messages", doc#id: "2e981fe8-ca05-4b7c-925d-9c5106c74558"): {
                                                            ee#message: {
                                                                    ee#"set-payload": "%dw 2.0\noutput application/json\n---\n{\n\tmessages: [ vars.slack_event.text],\n\tid: vars.slack_event.ts\n}" as String { cdata: true }
                                                                }
                                                        },
                                                    http#request @(method: "POST", doc#name: "Set status", doc#id: "4f36b1ec-de98-47b4-8a3f-89c3a164be03", "config-ref": "SlackAPI", path: "/api/assistant.threads.setStatus", target: "set_title"): {
                                                            http#body: "#[{\n   \"status\": \"Calculating the interest rate...\",\n   \"channel_id\": vars.slack_event.channel,\n   \"thread_ts\": vars.slack_event.thread_ts,\n}]" as String { cdata: true },
                                                            http#headers: "#[output application/json\n---\n{\n\tAuthorization: \"Bearer \" ++ p('slack.oauth_token')\n}]" as String { cdata: true }
                                                        },
                                                    a2a#"send-task" @(doc#name: "Send task", doc#id: "287285ed-7a66-48bc-9c23-06b542112bff", "config-ref": "A2A_Exchange_Agent"): {
                                                            a2a#task: "#[output application/json\n---\n{\n\t\"id\": payload.id,\n\t\"sessionId\": payload.id,\n\t\"acceptedOutputModes\": [\"text\"],\n\t\"message\": {\n\t\t\"role\": \"user\",\n\t\t\"parts\": (payload.messages map (message, indexOfMessage ) -> {\n\t\t\t\"type\": \"text\",\n\t\t\t\"text\": message\n\t\t})\n\t}\n}]" as String { cdata: true }
                                                        },                                                  
                                                    http#request @(method: "POST", doc#name: "Send Message", doc#id: "9a24a0fb-d5c3-4906-b6b5-13d9a1258a03", "config-ref": "SlackAPI", path: "/api/chat.postMessage"): {
                                                            http#body: "#[{\n   \"channel\": vars.slack_event.channel,\n   \"thread_ts\": vars.slack_event.ts,\n   \"text\": payload.status.message.parts[0].text default (payload.artifacts.parts[0].text joinBy \"\")\n}]" as String { cdata: true },
                                                            http#headers: "#[output application/json\n---\n{\n\tAuthorization: \"Bearer \" ++ p('slack.oauth_token')\n}]" as String { cdata: true }
                                                        }
                                                },
                                            ns1#otherwise: {
                                                    ns1#logger @(level: "INFO", doc#name: "Logger", doc#id: "674e0f68-e826-4b20-802c-6017c109762c", message: "ALREADY PROCESED #[payload.event.client_msg_id]"): null
                                                }
                                        }
                                },
                            ns1#when @(expression: "#[payload.'type' == \"url_verification\"]"):                             
                                {
                                    ns1#logger @(level: "INFO", doc#name: "Logger", doc#id: "c4d77b26-60e3-49e4-94df-36d24769dea6"): null,
                                    ee#transform @(doc#name: "Transform Message", doc#id: "60bd7e8a-1f82-474e-ba32-5caabdac3e16"): {
                                            ee#message: {
                                                    ee#"set-payload": "%dw 2.0\noutput application/json\n---\npayload.challenge" as String { cdata: true }
                                                }
                                        }
                                },
                            ns1#otherwise: {
                                    ns1#logger @(level: "DEBUG", doc#name: "Logger", doc#id: "4fde3e67-b382-43e0-8b42-115166c1934a", message: "IGNORE"): null
                                }
                        }
                }
        }
    
}