/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.CollectorContext;
import com.networknt.schema.DiscriminatorContext;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.ExecutionConfig;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.ExecutionContextCustomizer;
import com.networknt.schema.FailFastAssertionException;
import com.networknt.schema.InputFormat;
import com.networknt.schema.InvalidSchemaException;
import com.networknt.schema.InvalidSchemaRefException;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonSchemaIdValidator;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.Keyword;
import com.networknt.schema.OutputFormat;
import com.networknt.schema.PathType;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.TypeValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidationResult;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.i18n.MessageSource;
import com.networknt.schema.utils.JsonNodes;
import com.networknt.schema.utils.SetView;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public class JsonSchema
extends BaseJsonValidator {
    private static final long V201909_VALUE = SpecVersion.VersionFlag.V201909.getVersionFlagValue();
    private final String id;
    private List<JsonValidator> validators = null;
    private boolean validatorsLoaded = false;
    private boolean recursiveAnchor = false;
    private TypeValidator typeValidator = null;
    private static final Comparator<JsonValidator> VALIDATOR_SORT = (lhs, rhs) -> {
        String rhsName;
        String lhsName = lhs.getEvaluationPath().getName(-1);
        if (lhsName.equals(rhsName = rhs.getEvaluationPath().getName(-1))) {
            return 0;
        }
        if (lhsName.equals("properties")) {
            return -1;
        }
        if (rhsName.equals("properties")) {
            return 1;
        }
        if (lhsName.equals("patternProperties")) {
            return -1;
        }
        if (rhsName.equals("patternProperties")) {
            return 1;
        }
        if (lhsName.equals("unevaluatedItems")) {
            return 1;
        }
        if (rhsName.equals("unevaluatedItems")) {
            return -1;
        }
        if (lhsName.equals("unevaluatedProperties")) {
            return 1;
        }
        if (rhsName.equals("unevaluatedProperties")) {
            return -1;
        }
        return 0;
    };

    static JsonSchema from(ValidationContext validationContext, SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parent, boolean suppressSubSchemaRetrieval) {
        return new JsonSchema(validationContext, schemaLocation, evaluationPath, schemaNode, parent, suppressSubSchemaRetrieval);
    }

    private boolean hasNoFragment(SchemaLocation schemaLocation) {
        JsonNodePath fragment = this.schemaLocation.getFragment();
        return fragment == null || fragment.getParent() == null && fragment.getNameCount() == 0;
    }

    private static SchemaLocation resolve(SchemaLocation schemaLocation, JsonNode schemaNode, boolean rootSchema, ValidationContext validationContext) {
        String id = validationContext.resolveSchemaId(schemaNode);
        if (id != null) {
            String resolve2 = id;
            int fragment = id.indexOf(35);
            if (fragment != -1 && fragment + 1 < id.length()) {
                resolve2 = id.substring(0, fragment);
            }
            SchemaLocation result = !"".equals(resolve2) ? schemaLocation.resolve(resolve2) : schemaLocation;
            JsonSchemaIdValidator validator = validationContext.getConfig().getSchemaIdValidator();
            if (validator != null && !validator.validate(id, rootSchema, schemaLocation, result, validationContext)) {
                SchemaLocation idSchemaLocation = schemaLocation.append(validationContext.getMetaSchema().getIdKeyword());
                ValidationMessage validationMessage = ((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().code(ValidatorTypeCode.ID.getValue())).type(ValidatorTypeCode.ID.getValue())).instanceLocation(idSchemaLocation.getFragment())).arguments(id, validationContext.getMetaSchema().getIdKeyword(), idSchemaLocation)).schemaLocation(idSchemaLocation)).schemaNode(schemaNode)).messageFormatter(args -> validationContext.getConfig().getMessageSource().getMessage(ValidatorTypeCode.ID.getValue(), validationContext.getConfig().getLocale(), args))).build();
                throw new InvalidSchemaException(validationMessage);
            }
            return result;
        }
        return schemaLocation;
    }

    private JsonSchema(ValidationContext validationContext, SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parent, boolean suppressSubSchemaRetrieval) {
        super(JsonSchema.resolve(schemaLocation, schemaNode, parent == null, validationContext), evaluationPath, schemaNode, parent, null, null, validationContext, suppressSubSchemaRetrieval);
        String dynamicAnchor;
        String id = this.validationContext.resolveSchemaId(this.schemaNode);
        if (id != null) {
            SchemaLocation result = id.indexOf(35) != -1 ? schemaLocation.resolve(id) : this.schemaLocation;
            this.id = this.hasNoFragment(result) ? id : null;
            this.validationContext.getSchemaResources().putIfAbsent(result != null ? result.toString() : id, this);
        } else if (this.hasNoFragment(schemaLocation)) {
            this.id = schemaLocation.getAbsoluteIri() != null ? schemaLocation.getAbsoluteIri().toString() : "";
            this.validationContext.getSchemaResources().putIfAbsent(schemaLocation != null ? schemaLocation.toString() : this.id, this);
        } else {
            this.id = null;
        }
        String anchor = this.validationContext.getMetaSchema().readAnchor(this.schemaNode);
        if (anchor != null) {
            String absoluteIri = this.schemaLocation.getAbsoluteIri() != null ? this.schemaLocation.getAbsoluteIri().toString() : "";
            this.validationContext.getSchemaResources().putIfAbsent(absoluteIri + "#" + anchor, this);
        }
        if ((dynamicAnchor = this.validationContext.getMetaSchema().readDynamicAnchor(schemaNode)) != null) {
            String absoluteIri = this.schemaLocation.getAbsoluteIri() != null ? this.schemaLocation.getAbsoluteIri().toString() : "";
            this.validationContext.getDynamicAnchors().putIfAbsent(absoluteIri + "#" + dynamicAnchor, this);
        }
        this.getValidators();
    }

    protected JsonSchema(List<JsonValidator> validators, boolean validatorsLoaded, boolean recursiveAnchor, TypeValidator typeValidator, String id, boolean suppressSubSchemaRetrieval, JsonNode schemaNode, ValidationContext validationContext, ErrorMessageType errorMessageType, String errorMessageKeyword, MessageSource messageSource, Keyword keyword, JsonSchema parentSchema, SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonSchema evaluationParentSchema, Map<String, String> errorMessage) {
        super(suppressSubSchemaRetrieval, schemaNode, validationContext, errorMessageType, errorMessageKeyword, messageSource, keyword, parentSchema, schemaLocation, evaluationPath, evaluationParentSchema, errorMessage);
        this.validators = validators;
        this.validatorsLoaded = validatorsLoaded;
        this.recursiveAnchor = recursiveAnchor;
        this.typeValidator = typeValidator;
        this.id = id;
    }

    public JsonSchema fromRef(JsonSchema refEvaluationParentSchema, JsonNodePath refEvaluationPath) {
        ValidationContext validationContext = new ValidationContext(this.getValidationContext().getMetaSchema(), this.getValidationContext().getJsonSchemaFactory(), refEvaluationParentSchema.validationContext.getConfig(), refEvaluationParentSchema.getValidationContext().getSchemaReferences(), refEvaluationParentSchema.getValidationContext().getSchemaResources(), refEvaluationParentSchema.getValidationContext().getDynamicAnchors());
        JsonNodePath evaluationPath = refEvaluationPath;
        JsonSchema evaluationParentSchema = refEvaluationParentSchema;
        boolean validatorsLoaded = false;
        TypeValidator typeValidator = null;
        List<JsonValidator> validators = null;
        return new JsonSchema(validators, validatorsLoaded, this.recursiveAnchor, typeValidator, this.id, this.suppressSubSchemaRetrieval, this.schemaNode, validationContext, this.errorMessageType, this.errorMessageKeyword, this.messageSource, this.keyword, this.parentSchema, this.schemaLocation, evaluationPath, evaluationParentSchema, this.errorMessage);
    }

    public JsonSchema withConfig(SchemaValidatorsConfig config) {
        if (this.getValidationContext().getMetaSchema().getKeywords().containsKey("discriminator") && !config.isDiscriminatorKeywordEnabled()) {
            config = SchemaValidatorsConfig.builder(config).discriminatorKeywordEnabled(true).nullableKeywordEnabled(true).build();
        }
        if (!this.getValidationContext().getConfig().equals(config)) {
            ValidationContext validationContext = new ValidationContext(this.getValidationContext().getMetaSchema(), this.getValidationContext().getJsonSchemaFactory(), config, this.getValidationContext().getSchemaReferences(), this.getValidationContext().getSchemaResources(), this.getValidationContext().getDynamicAnchors());
            boolean validatorsLoaded = false;
            TypeValidator typeValidator = null;
            List<JsonValidator> validators = null;
            return new JsonSchema(validators, validatorsLoaded, this.recursiveAnchor, typeValidator, this.id, this.suppressSubSchemaRetrieval, this.schemaNode, validationContext, this.errorMessageType, this.errorMessageKeyword, this.messageSource, this.keyword, this.parentSchema, this.schemaLocation, this.evaluationPath, this.evaluationParentSchema, this.errorMessage);
        }
        return this;
    }

    public ValidationContext getValidationContext() {
        return this.validationContext;
    }

    public JsonNode getRefSchemaNode(String ref) {
        JsonSchema schema = this.findSchemaResourceRoot();
        JsonNode node = schema.getSchemaNode();
        String jsonPointer = ref;
        if (schema.getId() != null && ref.startsWith(schema.getId())) {
            String refValue;
            jsonPointer = refValue = ref.substring(schema.getId().length());
        }
        if (jsonPointer.startsWith("#/")) {
            jsonPointer = jsonPointer.substring(1);
        }
        if (jsonPointer.startsWith("/")) {
            try {
                jsonPointer = URLDecoder.decode(jsonPointer, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            node = node.at(jsonPointer);
            if (node.isMissingNode()) {
                node = this.handleNullNode(ref, schema);
            }
        }
        return node;
    }

    public JsonSchema getRefSchema(JsonNodePath fragment) {
        if (PathType.JSON_POINTER.equals((Object)fragment.getPathType())) {
            return this.getSubSchema(fragment);
        }
        String base = this.getSchemaLocation().getAbsoluteIri() != null ? this.schemaLocation.getAbsoluteIri().toString() : "";
        String anchor = base + "#" + fragment;
        JsonSchema result = (JsonSchema)this.validationContext.getSchemaResources().get(anchor);
        if (result == null) {
            result = (JsonSchema)this.validationContext.getDynamicAnchors().get(anchor);
        }
        if (result == null) {
            throw new JsonSchemaException("Unable to find anchor " + anchor);
        }
        return result;
    }

    public JsonSchema getSubSchema(JsonNodePath fragment) {
        JsonSchema document;
        JsonSchema parent = document = this.findSchemaResourceRoot();
        JsonSchema subSchema = null;
        JsonNode parentNode = parent.getSchemaNode();
        SchemaLocation schemaLocation = document.getSchemaLocation();
        JsonNodePath evaluationPath = document.getEvaluationPath();
        int nameCount = fragment.getNameCount();
        for (int x = 0; x < nameCount; ++x) {
            Object segment = fragment.getElement(x);
            JsonNode subSchemaNode = this.getNode(parentNode, segment);
            if (subSchemaNode != null) {
                if (segment instanceof Number && parentNode.isArray()) {
                    int index = ((Number)segment).intValue();
                    schemaLocation = schemaLocation.append(index);
                    evaluationPath = evaluationPath.append(index);
                } else {
                    schemaLocation = schemaLocation.append(segment.toString());
                    evaluationPath = evaluationPath.append(segment.toString());
                }
                String id = parent.getValidationContext().resolveSchemaId(subSchemaNode);
                if (id != null || x == nameCount - 1) {
                    parent = subSchema = parent.getValidationContext().newSchema(schemaLocation, evaluationPath, subSchemaNode, parent);
                    schemaLocation = subSchema.getSchemaLocation();
                }
            } else {
                JsonSchema found = document.findSchemaResourceRoot().fetchSubSchemaNode(this.validationContext);
                if (found != null) {
                    found = found.getSubSchema(fragment);
                }
                if (found == null) {
                    ValidationMessage validationMessage = ((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().type(ValidatorTypeCode.REF.getValue())).code("internal.unresolvedRef")).message("{0}: Reference {1} cannot be resolved")).instanceLocation(schemaLocation.getFragment())).schemaLocation(schemaLocation)).evaluationPath(evaluationPath)).arguments(fragment)).build();
                    throw new InvalidSchemaRefException(validationMessage);
                }
                return found;
            }
            parentNode = subSchemaNode;
        }
        return subSchema;
    }

    protected JsonNode getNode(Object propertyOrIndex) {
        return this.getNode(this.schemaNode, propertyOrIndex);
    }

    protected JsonNode getNode(JsonNode node, Object propertyOrIndex) {
        return JsonNodes.get(node, propertyOrIndex);
    }

    public JsonSchema findLexicalRoot() {
        JsonSchema ancestor = this;
        while (ancestor.getId() == null && null != ancestor.getParentSchema()) {
            ancestor = ancestor.getParentSchema();
        }
        return ancestor;
    }

    public JsonSchema findSchemaResourceRoot() {
        JsonSchema ancestor = this;
        while (!ancestor.isSchemaResourceRoot()) {
            ancestor = ancestor.getParentSchema();
        }
        return ancestor;
    }

    public boolean isSchemaResourceRoot() {
        if (this.getId() != null) {
            return true;
        }
        if (this.getParentSchema() == null) {
            return true;
        }
        return !Objects.equals(this.getSchemaLocation().getAbsoluteIri(), this.getParentSchema().getSchemaLocation().getAbsoluteIri());
    }

    public String getId() {
        return this.id;
    }

    public JsonSchema findAncestor() {
        JsonSchema ancestor = this;
        if (this.getParentSchema() != null) {
            ancestor = this.getParentSchema().findAncestor();
        }
        return ancestor;
    }

    private JsonNode handleNullNode(String ref, JsonSchema schema) {
        JsonSchema subSchema = schema.fetchSubSchemaNode(this.validationContext);
        if (subSchema != null) {
            return subSchema.getRefSchemaNode(ref);
        }
        return null;
    }

    private List<JsonValidator> read(JsonNode schemaNode) {
        ArrayList<JsonValidator> validators;
        if (schemaNode.isBoolean()) {
            validators = new ArrayList<JsonValidator>(1);
            if (schemaNode.booleanValue()) {
                JsonNodePath path = this.getEvaluationPath().append("true");
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaLocation().append("true"), path, "true", schemaNode, this);
                validators.add(validator);
            } else {
                JsonNodePath path = this.getEvaluationPath().append("false");
                JsonValidator validator = this.validationContext.newValidator(this.getSchemaLocation().append("false"), path, "false", schemaNode, this);
                validators.add(validator);
            }
        } else {
            JsonValidator refValidator = null;
            Iterator<Map.Entry<String, JsonNode>> iterator = schemaNode.fields();
            validators = new ArrayList(schemaNode.size());
            while (iterator.hasNext()) {
                JsonValidator validator;
                Map.Entry<String, JsonNode> entry = iterator.next();
                String pname = entry.getKey();
                JsonNode nodeToUse = entry.getValue();
                JsonNodePath path = this.getEvaluationPath().append(pname);
                SchemaLocation schemaPath = this.getSchemaLocation().append(pname);
                if ("$recursiveAnchor".equals(pname)) {
                    if (!nodeToUse.isBoolean()) {
                        ValidationMessage validationMessage = ((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)((ValidationMessage.Builder)ValidationMessage.builder().type("$recursiveAnchor")).code("internal.invalidRecursiveAnchor")).message("{0}: The value of a $recursiveAnchor must be a Boolean literal but is {1}")).instanceLocation(path)).evaluationPath(path)).schemaLocation(schemaPath)).arguments(nodeToUse.getNodeType().toString())).build();
                        throw new JsonSchemaException(validationMessage);
                    }
                    this.recursiveAnchor = nodeToUse.booleanValue();
                }
                if ((validator = this.validationContext.newValidator(schemaPath, path, pname, nodeToUse, this)) == null) continue;
                validators.add(validator);
                if ("$ref".equals(pname)) {
                    refValidator = validator;
                    continue;
                }
                if (!"type".equals(pname) || !(validator instanceof TypeValidator)) continue;
                this.typeValidator = (TypeValidator)validator;
            }
            if (null != refValidator && this.activeDialect() < V201909_VALUE) {
                validators.clear();
                validators.add(refValidator);
            }
        }
        if (validators.size() > 1) {
            Collections.sort(validators, VALIDATOR_SORT);
        }
        return validators;
    }

    private long activeDialect() {
        return this.validationContext.activeDialect().map(SpecVersion.VersionFlag::getVersionFlagValue).orElse(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode jsonNode, JsonNode rootNode, JsonNodePath instanceLocation) {
        DiscriminatorContext discriminatorContext;
        ObjectNode discriminator;
        ObjectNode discriminator2;
        if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled() && null != (discriminator2 = (ObjectNode)this.schemaNode.get("discriminator")) && null != executionContext.getCurrentDiscriminatorContext()) {
            executionContext.getCurrentDiscriminatorContext().registerDiscriminator(this.schemaLocation, discriminator2);
        }
        SetView<ValidationMessage> errors = null;
        for (JsonValidator v : this.getValidators()) {
            Set<ValidationMessage> results = null;
            try {
                results = v.validate(executionContext, jsonNode, rootNode, instanceLocation);
                if (results == null || results.isEmpty()) continue;
                if (errors == null) {
                    errors = new SetView();
                }
                errors.union(results);
            }
            catch (Throwable throwable) {
                if (results != null && !results.isEmpty()) {
                    if (errors == null) {
                        errors = new SetView<ValidationMessage>();
                    }
                    errors.union(results);
                }
                throw throwable;
            }
        }
        if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled() && null != (discriminator = (ObjectNode)this.schemaNode.get("discriminator")) && null != (discriminatorContext = executionContext.getCurrentDiscriminatorContext())) {
            ObjectNode discriminatorToUse;
            ObjectNode discriminatorFromContext = discriminatorContext.getDiscriminatorForPath(this.schemaLocation);
            if (null == discriminatorFromContext) {
                discriminatorContext.registerDiscriminator(this.schemaLocation, discriminator);
                discriminatorToUse = discriminator;
            } else {
                discriminatorToUse = discriminatorFromContext;
            }
            String discriminatorPropertyName = discriminatorToUse.get("propertyName").asText();
            JsonNode discriminatorNode = jsonNode.get(discriminatorPropertyName);
            String discriminatorPropertyValue = discriminatorNode == null ? null : discriminatorNode.asText();
            JsonSchema.checkDiscriminatorMatch(discriminatorContext, discriminatorToUse, discriminatorPropertyValue, this);
        }
        if (errors != null && !errors.isEmpty()) {
            executionContext.getResults().setResult(instanceLocation, this.getSchemaLocation(), this.getEvaluationPath(), false);
        }
        return errors == null ? Collections.emptySet() : errors;
    }

    public Set<ValidationMessage> validate(JsonNode rootNode) {
        return this.validate(rootNode, OutputFormat.DEFAULT);
    }

    public Set<ValidationMessage> validate(JsonNode rootNode, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(rootNode, OutputFormat.DEFAULT, executionCustomizer);
    }

    public Set<ValidationMessage> validate(JsonNode rootNode, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(rootNode, OutputFormat.DEFAULT, executionCustomizer);
    }

    public <T> T validate(JsonNode rootNode, OutputFormat<T> format) {
        return this.validate(rootNode, format, (ExecutionContextCustomizer)null);
    }

    public <T> T validate(JsonNode rootNode, OutputFormat<T> format, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(this.createExecutionContext(), rootNode, format, executionCustomizer);
    }

    public <T> T validate(JsonNode rootNode, OutputFormat<T> format, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(this.createExecutionContext(), rootNode, format, (ExecutionContext executionContext, ValidationContext validationContext) -> executionCustomizer.accept(executionContext));
    }

    public Set<ValidationMessage> validate(String input, InputFormat inputFormat) {
        return this.validate(this.deserialize(input, inputFormat), OutputFormat.DEFAULT);
    }

    public Set<ValidationMessage> validate(String input, InputFormat inputFormat, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(this.deserialize(input, inputFormat), OutputFormat.DEFAULT, executionCustomizer);
    }

    public Set<ValidationMessage> validate(String input, InputFormat inputFormat, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(this.deserialize(input, inputFormat), OutputFormat.DEFAULT, executionCustomizer);
    }

    public <T> T validate(String input, InputFormat inputFormat, OutputFormat<T> format) {
        return this.validate(this.deserialize(input, inputFormat), format, (ExecutionContextCustomizer)null);
    }

    public <T> T validate(String input, InputFormat inputFormat, OutputFormat<T> format, ExecutionContextCustomizer executionCustomizer) {
        return this.validate(this.createExecutionContext(), this.deserialize(input, inputFormat), format, executionCustomizer);
    }

    public <T> T validate(String input, InputFormat inputFormat, OutputFormat<T> format, Consumer<ExecutionContext> executionCustomizer) {
        return this.validate(this.createExecutionContext(), this.deserialize(input, inputFormat), format, (ExecutionContext executionContext, ValidationContext validationContext) -> executionCustomizer.accept(executionContext));
    }

    public <T> T validate(ExecutionContext executionContext, JsonNode node, OutputFormat<T> format) {
        return this.validate(executionContext, node, format, null);
    }

    public <T> T validate(ExecutionContext executionContext, JsonNode node, OutputFormat<T> format, ExecutionContextCustomizer executionCustomizer) {
        format.customize(executionContext, this.validationContext);
        if (executionCustomizer != null) {
            executionCustomizer.customize(executionContext, this.validationContext);
        }
        Set<ValidationMessage> validationMessages = null;
        try {
            validationMessages = this.validate(executionContext, node);
        }
        catch (FailFastAssertionException e) {
            validationMessages = e.getValidationMessages();
        }
        return format.format(this, validationMessages, executionContext, this.validationContext);
    }

    private JsonNode deserialize(String input, InputFormat inputFormat) {
        try {
            return this.getValidationContext().getJsonSchemaFactory().readTree(input, inputFormat);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid input", e);
        }
    }

    @Deprecated
    public ValidationResult validateAndCollect(ExecutionContext executionContext, JsonNode node) {
        return this.validateAndCollect(executionContext, node, node, this.atRoot());
    }

    @Deprecated
    private ValidationResult validateAndCollect(ExecutionContext executionContext, JsonNode jsonNode, JsonNode rootNode, JsonNodePath instanceLocation) {
        Set<ValidationMessage> errors = this.validate(executionContext, jsonNode, rootNode, instanceLocation);
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        if (config.doLoadCollectors()) {
            CollectorContext collectorContext = executionContext.getCollectorContext();
            collectorContext.loadCollectors();
        }
        return new ValidationResult(errors, executionContext);
    }

    @Deprecated
    public ValidationResult validateAndCollect(JsonNode node) {
        return this.validateAndCollect(this.createExecutionContext(), node, node, this.atRoot());
    }

    public ValidationResult walk(ExecutionContext executionContext, JsonNode node, boolean validate, ExecutionContextCustomizer executionCustomizer) {
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, OutputFormat.RESULT, executionCustomizer);
    }

    public <T> T walk(ExecutionContext executionContext, JsonNode node, OutputFormat<T> outputFormat, boolean validate, ExecutionContextCustomizer executionCustomizer) {
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, outputFormat, executionCustomizer);
    }

    public ValidationResult walk(ExecutionContext executionContext, JsonNode node, boolean validate, Consumer<ExecutionContext> executionCustomizer) {
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, OutputFormat.RESULT, executionCustomizer);
    }

    public <T> T walk(ExecutionContext executionContext, JsonNode node, OutputFormat<T> outputFormat, boolean validate, Consumer<ExecutionContext> executionCustomizer) {
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, outputFormat, executionCustomizer);
    }

    public ValidationResult walk(ExecutionContext executionContext, JsonNode node, boolean validate) {
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, OutputFormat.RESULT, (ExecutionContextCustomizer)null);
    }

    public ValidationResult walk(ExecutionContext executionContext, String input, InputFormat inputFormat, boolean validate) {
        JsonNode node = this.deserialize(input, inputFormat);
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, OutputFormat.RESULT, (ExecutionContextCustomizer)null);
    }

    public <T> T walk(ExecutionContext executionContext, String input, InputFormat inputFormat, OutputFormat<T> outputFormat, boolean validate) {
        JsonNode node = this.deserialize(input, inputFormat);
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, outputFormat, (ExecutionContextCustomizer)null);
    }

    public ValidationResult walk(ExecutionContext executionContext, String input, InputFormat inputFormat, boolean validate, ExecutionContextCustomizer executionCustomizer) {
        JsonNode node = this.deserialize(input, inputFormat);
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, OutputFormat.RESULT, executionCustomizer);
    }

    public <T> T walk(ExecutionContext executionContext, String input, InputFormat inputFormat, OutputFormat<T> outputFormat, boolean validate, ExecutionContextCustomizer executionCustomizer) {
        JsonNode node = this.deserialize(input, inputFormat);
        return this.walkAtNodeInternal(executionContext, node, node, this.atRoot(), validate, outputFormat, executionCustomizer);
    }

    public ValidationResult walk(JsonNode node, boolean validate) {
        return this.walk(this.createExecutionContext(), node, validate);
    }

    public <T> T walk(JsonNode node, OutputFormat<T> outputFormat, boolean validate) {
        return this.walk(this.createExecutionContext(), node, outputFormat, validate, (ExecutionContextCustomizer)null);
    }

    public ValidationResult walk(String input, InputFormat inputFormat, boolean validate) {
        return this.walk(this.createExecutionContext(), this.deserialize(input, inputFormat), validate);
    }

    public ValidationResult walk(String input, InputFormat inputFormat, boolean validate, ExecutionContextCustomizer executionCustomizer) {
        return this.walk(this.createExecutionContext(), this.deserialize(input, inputFormat), validate, executionCustomizer);
    }

    public ValidationResult walk(String input, InputFormat inputFormat, boolean validate, Consumer<ExecutionContext> executionCustomizer) {
        return this.walk(this.createExecutionContext(), this.deserialize(input, inputFormat), validate, executionCustomizer);
    }

    public ValidationResult walkAtNode(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean validate) {
        return this.walkAtNodeInternal(executionContext, node, rootNode, instanceLocation, validate, OutputFormat.RESULT, (ExecutionContextCustomizer)null);
    }

    private <T> T walkAtNodeInternal(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean validate, OutputFormat<T> format, Consumer<ExecutionContext> executionCustomizer) {
        return this.walkAtNodeInternal(executionContext, node, rootNode, instanceLocation, validate, format, (ExecutionContext executeContext, ValidationContext validationContext) -> executionCustomizer.accept(executeContext));
    }

    private <T> T walkAtNodeInternal(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean validate, OutputFormat<T> format, ExecutionContextCustomizer executionCustomizer) {
        if (executionCustomizer != null) {
            executionCustomizer.customize(executionContext, this.validationContext);
        }
        Set<ValidationMessage> errors = this.walk(executionContext, node, rootNode, instanceLocation, validate);
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        if (config.doLoadCollectors()) {
            CollectorContext collectorContext = executionContext.getCollectorContext();
            collectorContext.loadCollectors();
        }
        return format.format(this, errors, executionContext, this.validationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        LinkedHashSet<ValidationMessage> errors = new LinkedHashSet<ValidationMessage>();
        for (JsonValidator validator : this.getValidators()) {
            JsonNodePath evaluationPathWithKeyword = validator.getEvaluationPath();
            try {
                if (!this.validationContext.getConfig().getKeywordWalkListenerRunner().runPreWalkListeners(executionContext, evaluationPathWithKeyword.getName(-1), node, rootNode, instanceLocation, this, validator)) continue;
                Set<ValidationMessage> results = null;
                try {
                    results = validator.walk(executionContext, node, rootNode, instanceLocation, shouldValidateSchema);
                }
                finally {
                    if (results == null || results.isEmpty()) continue;
                    errors.addAll(results);
                }
            }
            finally {
                this.validationContext.getConfig().getKeywordWalkListenerRunner().runPostWalkListeners(executionContext, evaluationPathWithKeyword.getName(-1), node, rootNode, instanceLocation, this, validator, errors);
            }
        }
        return errors;
    }

    @Override
    public String toString() {
        return "\"" + this.getEvaluationPath() + "\" : " + this.getSchemaNode().toString();
    }

    public boolean hasTypeValidator() {
        return this.getTypeValidator() != null;
    }

    public TypeValidator getTypeValidator() {
        if (this.validators == null) {
            this.getValidators();
        }
        return this.typeValidator;
    }

    public List<JsonValidator> getValidators() {
        if (this.validators == null) {
            this.validators = Collections.unmodifiableList(this.read(this.getSchemaNode()));
        }
        return this.validators;
    }

    public void initializeValidators() {
        if (!this.validatorsLoaded) {
            for (JsonValidator validator : this.getValidators()) {
                validator.preloadJsonSchema();
            }
            this.validatorsLoaded = true;
        }
    }

    public boolean isRecursiveAnchor() {
        return this.recursiveAnchor;
    }

    public ExecutionContext createExecutionContext() {
        SchemaValidatorsConfig config = this.validationContext.getConfig();
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.setLocale(config.getLocale());
        executionConfig.setFormatAssertionsEnabled(config.getFormatAssertionsEnabled());
        executionConfig.setFailFast(config.isFailFast());
        ExecutionContext executionContext = new ExecutionContext(executionConfig);
        if (config.getExecutionContextCustomizer() != null) {
            config.getExecutionContextCustomizer().customize(executionContext, this.validationContext);
        }
        return executionContext;
    }
}

