/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.module.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.mule.weave.v2.module.reader.CharsetEncoder;
import org.mule.weave.v2.module.reader.CharsetEncoder$;
import org.mule.weave.v2.module.reader.StreamDecoder$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Us!B\u000f\u001f\u0011\u0003Yc!B\u0017\u001f\u0011\u0003q\u0003\"B\u001b\u0002\t\u00031\u0004bB\u001c\u0002\u0005\u0004%I\u0001\u000f\u0005\u0007y\u0005\u0001\u000b\u0011B\u001d\t\u000bu\nA\u0011\u0001 \u0007\t5r\u0002\u0001\u0011\u0005\t\u0003\u001a\u0011)\u0019!C\u0001\u0005\"A1J\u0002B\u0001B\u0003%1\t\u0003\u0005M\r\t\u0015\r\u0011\"\u0001N\u0011!1fA!A!\u0002\u0013q\u0005\"B\u001b\u0007\t\u00039\u0006b\u0002.\u0007\u0005\u0004%Ia\u0017\u0005\u0007?\u001a\u0001\u000b\u0011\u0002/\t\u0011\u00014\u0001R1A\u0005\n\u0005D\u0001B\u001a\u0004\t\u0006\u0004%Ia\u001a\u0005\bW\u001a\u0001\r\u0011\"\u0003m\u0011\u001d\u0001h\u00011A\u0005\nEDaa\u001e\u0004!B\u0013i\u0007b\u0002=\u0007\u0001\u0004%I!\u001f\u0005\b{\u001a\u0001\r\u0011\"\u0003\u007f\u0011\u001d\t\tA\u0002Q!\niDq!a\u0001\u0007\t\u0003\t)\u0001C\u0004\u0002\b\u0019!\t!!\u0003\t\u000f\u0005=a\u0001\"\u0001\u0002\u0012!9\u00111\u0003\u0004\u0005\u0002\u0005\u0015\u0001bBA\u0013\r\u0011\u0005\u0011q\u0005\u0005\u0007\u0003{1A\u0011\u0002\u001d\t\u000f\u0005\u0005c\u0001\"\u0003\u0002D\u0005i1\u000b\u001e:fC6$UmY8eKJT!a\b\u0011\u0002\rI,\u0017\rZ3s\u0015\t\t#%\u0001\u0004n_\u0012,H.\u001a\u0006\u0003G\u0011\n!A\u001e\u001a\u000b\u0005\u00152\u0013!B<fCZ,'BA\u0014)\u0003\u0011iW\u000f\\3\u000b\u0003%\n1a\u001c:h\u0007\u0001\u0001\"\u0001L\u0001\u000e\u0003y\u0011Qb\u0015;sK\u0006lG)Z2pI\u0016\u00148CA\u00010!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aK\u0001\u0019\t\u00163\u0015)\u0016'U?\nKF+R0C+\u001a3UIU0T\u0013j+U#A\u001d\u0011\u0005AR\u0014BA\u001e2\u0005\rIe\u000e^\u0001\u001a\t\u00163\u0015)\u0016'U?\nKF+R0C+\u001a3UIU0T\u0013j+\u0005%\u0001\u000bg_JLe\u000e];u'R\u0014X-Y7SK\u0006$WM\u001d\u000b\u0006\u007f\u0005E\u00131\u000b\t\u0003Y\u0019\u0019\"AB\u0018\u0002\u0005%tW#A\"\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015AA5p\u0015\u0005A\u0015\u0001\u00026bm\u0006L!AS#\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\u0004S:\u0004\u0013AA2t+\u0005q\u0005CA(U\u001b\u0005\u0001&BA)S\u0003\u001d\u0019\u0007.\u0019:tKRT!aU$\u0002\u00079Lw.\u0003\u0002V!\n91\t[1sg\u0016$\u0018aA2tAQ\u0019q\bW-\t\u000b\u0005[\u0001\u0019A\"\t\u000b1[\u0001\u0019\u0001(\u0002\u000f\u0011,7m\u001c3feV\tA\f\u0005\u0002P;&\u0011a\f\u0015\u0002\u000f\u0007\"\f'o]3u\t\u0016\u001cw\u000eZ3s\u0003!!WmY8eKJ\u0004\u0013A\u00012c+\u0005\u0011\u0007CA2e\u001b\u0005\u0011\u0016BA3S\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\bK:\u001cw\u000eZ3s+\u0005A\u0007C\u0001\u0017j\u0013\tQgD\u0001\bDQ\u0006\u00148/\u001a;F]\u000e|G-\u001a:\u0002!!\fg/\u001a'fMR|g/\u001a:DQ\u0006\u0014X#A7\u0011\u0005Ar\u0017BA82\u0005\u001d\u0011un\u001c7fC:\fA\u0003[1wK2+g\r^8wKJ\u001c\u0005.\u0019:`I\u0015\fHC\u0001:v!\t\u00014/\u0003\u0002uc\t!QK\\5u\u0011\u001d1\u0018#!AA\u00025\f1\u0001\u001f\u00132\u0003EA\u0017M^3MK\u001a$xN^3s\u0007\"\f'\u000fI\u0001\rY\u00164Go\u001c<fe\u000eC\u0017M]\u000b\u0002uB\u0011\u0001g_\u0005\u0003yF\u0012Aa\u00115be\u0006\u0001B.\u001a4u_Z,'o\u00115be~#S-\u001d\u000b\u0003e~DqA\u001e\u000b\u0002\u0002\u0003\u0007!0A\u0007mK\u001a$xN^3s\u0007\"\f'\u000fI\u0001\u0016e\u0016l\u0017-\u001b8j]\u001e\u0014\u0015\u0010^3t\u0013:\u001c\u0015m\u00195f)\u0005I\u0014a\u00032zi\u0016\u001cH*\u001a8hi\"$2!OA\u0006\u0011\u0019\tia\u0006a\u0001u\u0006\t1-A\u0003dY\u0016\f'\u000fF\u0001s\u0003\u0019!WmY8eK\"*\u0011$a\u0006\u0002$A)\u0001'!\u0007\u0002\u001e%\u0019\u00111D\u0019\u0003\rQD'o\\<t!\r!\u0015qD\u0005\u0004\u0003C)%aC%P\u000bb\u001cW\r\u001d;j_:\u001c#!!\b\u0002\tI,\u0017\r\u001a\u000b\bs\u0005%\u00121GA\u001c\u0011\u001d\tYC\u0007a\u0001\u0003[\tAa\u00192vMB!\u0001'a\f{\u0013\r\t\t$\r\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0007\u0003kQ\u0002\u0019A\u001d\u0002\r=4gm]3u\u0011\u0019\tID\u0007a\u0001s\u00051A.\u001a8hi\"DSAGA\f\u0003G\t\u0011B]3bI\nKH/Z:)\u000bm\t9\"a\t\u0002\u0011%l\u0007\u000f\u001c*fC\u0012$r!OA#\u0003\u000f\nY\u0005C\u0004\u0002,q\u0001\r!!\f\t\r\u0005%C\u00041\u0001:\u0003\rygM\u001a\u0005\u0007\u0003\u001bb\u0002\u0019A\u001d\u0002\u0007\u0015tG\rK\u0003\u001d\u0003/\t\u0019\u0003C\u0003B\u000b\u0001\u00071\tC\u0003M\u000b\u0001\u0007a\n")
public class StreamDecoder {
    private ByteBuffer bb;
    private CharsetEncoder encoder;
    private final InputStream in;
    private final Charset cs;
    private final CharsetDecoder decoder;
    private boolean haveLeftoverChar;
    private char leftoverChar;
    private volatile byte bitmap$0;

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Charset charset) {
        return StreamDecoder$.MODULE$.forInputStreamReader(inputStream, charset);
    }

    public InputStream in() {
        return this.in;
    }

    public Charset cs() {
        return this.cs;
    }

    private CharsetDecoder decoder() {
        return this.decoder;
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuffer bb$lzycompute() {
        StreamDecoder streamDecoder = this;
        synchronized (streamDecoder) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                ByteBuffer byteBuffer = ByteBuffer.allocate(StreamDecoder$.MODULE$.org$mule$weave$v2$module$reader$StreamDecoder$$DEFAULT_BYTE_BUFFER_SIZE());
                byteBuffer.flip();
                this.bb = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.bb;
    }

    private ByteBuffer bb() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.bb$lzycompute();
        }
        return this.bb;
    }

    private CharsetEncoder encoder$lzycompute() {
        StreamDecoder streamDecoder = this;
        synchronized (streamDecoder) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.encoder = CharsetEncoder$.MODULE$.apply(this.cs());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.encoder;
    }

    private CharsetEncoder encoder() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.encoder$lzycompute();
        }
        return this.encoder;
    }

    private boolean haveLeftoverChar() {
        return this.haveLeftoverChar;
    }

    private void haveLeftoverChar_$eq(boolean x$1) {
        this.haveLeftoverChar = x$1;
    }

    private char leftoverChar() {
        return this.leftoverChar;
    }

    private void leftoverChar_$eq(char x$1) {
        this.leftoverChar = x$1;
    }

    public int remainingBytesInCache() {
        int remaining;
        block0: {
            remaining = this.bb().remaining();
            if (!this.haveLeftoverChar()) break block0;
            remaining += this.bytesLength(this.leftoverChar());
        }
        return remaining;
    }

    public int bytesLength(char c) {
        return this.encoder().bytesLength(c);
    }

    public void clear() {
        this.bb().clear();
        this.bb().flip();
        this.haveLeftoverChar_$eq(false);
    }

    public int decode() throws IOException {
        int n;
        if (this.haveLeftoverChar()) {
            this.haveLeftoverChar_$eq(false);
            return this.leftoverChar();
        }
        char[] cb = new char[2];
        int n2 = n = this.read(cb, 0, cb.length);
        switch (n2) {
            case 2: {
                this.leftoverChar_$eq(cb[1]);
                this.haveLeftoverChar_$eq(true);
                return cb[0];
            }
            case 1: {
                return cb[0];
            }
        }
        return -1;
    }

    public int read(char[] cbuf, int offset, int length) throws IOException {
        if (offset < 0 || offset > cbuf.length || length < 0 || offset + length > cbuf.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        return this.implRead(cbuf, offset, offset + length);
    }

    private int readBytes() throws IOException {
        block6: {
            int n;
            block5: {
                this.bb().compact();
                try {
                    int lim = this.bb().limit();
                    int pos = this.bb().position();
                    int rem = pos <= lim ? lim - pos : 0;
                    int n2 = this.in().read(this.bb().array(), this.bb().arrayOffset() + pos, rem);
                    if (n2 < 0) {
                        n = n2;
                        break block5;
                    }
                    if (n2 == 0) {
                        throw new IOException("Underlying input stream returned zero bytes");
                    }
                    this.bb().position(pos + n2);
                    break block6;
                }
                finally {
                    this.bb().flip();
                }
            }
            return n;
        }
        return this.bb().remaining();
    }

    private int implRead(char[] cbuf, int off, int end) throws IOException {
        CharBuffer cb = CharBuffer.wrap(cbuf, off, end - off);
        if (cb.position() != 0) {
            cb = cb.slice();
        }
        boolean eof = false;
        boolean needMoreBytes = true;
        Serializable serializable = this.bb().remaining() == 0 ? BoxesRunTime.boxToInteger(this.readBytes()) : BoxedUnit.UNIT;
        while (needMoreBytes) {
            Object object;
            CoderResult cr = this.decoder().decode(this.bb(), cb, eof);
            if (cr.isUnderflow()) {
                if (eof) {
                    needMoreBytes = false;
                    object = BoxedUnit.UNIT;
                    continue;
                }
                if (!cb.hasRemaining()) {
                    needMoreBytes = false;
                    object = BoxedUnit.UNIT;
                    continue;
                }
                if (cb.position() > 0) {
                    needMoreBytes = false;
                    object = BoxedUnit.UNIT;
                    continue;
                }
                int n = this.readBytes();
                if (n < 0) {
                    eof = true;
                    if (cb.position() == 0 && !this.bb().hasRemaining()) {
                        needMoreBytes = false;
                        object = BoxedUnit.UNIT;
                        continue;
                    }
                    object = this.decoder().reset();
                    continue;
                }
                object = BoxedUnit.UNIT;
                continue;
            }
            if (cr.isOverflow()) {
                needMoreBytes = false;
            } else {
                cr.throwException();
            }
            object = BoxedUnit.UNIT;
        }
        Object object = eof ? this.decoder().reset() : BoxedUnit.UNIT;
        if (cb.position() == 0 && eof) {
            return -1;
        }
        return cb.position();
    }

    public StreamDecoder(InputStream in, Charset cs) {
        this.in = in;
        this.cs = cs;
        this.decoder = cs.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.haveLeftoverChar = false;
        this.leftoverChar = '\u0000';
    }
}

