/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.anypoint.agent.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ScriptingBindings;
import scala.Option;

public class MuleAppGenerator {
    public static final String MULE_ARTIFACT_JSON = "mule-artifact.json";
    public static final String LOG4J_CONFIG = "app-log4j.xml-template";
    public static final String MULE_AGENT_XML = "mule-agent.xml";
    public static final String APPLICATION_YAML = "application/yaml";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_JAVA = "application/java";
    public static final String MVNW_CMD = "mvnw.cmd";
    public static final String MVNW = "mvnw";
    public static final String MAVEN_WRAPPER_PROPERTIES = "maven-wrapper.properties";
    public static final String GENERATE = "generate";
    public static final String PAYLOAD = "payload";
    private final DataWeaveScriptingEngine dataWeaveScriptingEngine = new DataWeaveScriptingEngine();

    public void generateMuleApp(File mainFile, File exchangeJsonFile, Boolean lowerEnv, String modulesPath, File outputDirectory, Map<String, String> versions) {
        try {
            FileOutputStream mvnwOut;
            File file;
            outputDirectory.mkdirs();
            DataWeaveScript muleAppGenerator = this.dataWeaveScriptingEngine.compile(NameIdentifier.apply((String)"MuleAppGenerator", (Option)Option.empty()));
            try (FileInputStream fabricFileStream = new FileInputStream(mainFile);){
                File srcMuleDir = new File(outputDirectory, "src" + File.separator + "main" + File.separator + "mule");
                srcMuleDir.mkdirs();
                File outputFile = new File(srcMuleDir, MULE_AGENT_XML);
                ScriptingBindings bindings = new ScriptingBindings().addBinding(PAYLOAD, (Object)fabricFileStream, APPLICATION_YAML).addBinding("exchange", (Object)exchangeJsonFile, APPLICATION_JSON).addBinding("env", Map.of("lowerEnv", lowerEnv, "modulesPath", modulesPath), APPLICATION_JAVA);
                muleAppGenerator.write(bindings, ServiceManager.apply(), Option.apply((Object)outputFile));
            }
            File resourcesMuleDir = new File(outputDirectory, "src" + File.separator + "main" + File.separator + "resources");
            resourcesMuleDir.mkdirs();
            DataWeaveScript configYaml = this.dataWeaveScriptingEngine.compile(NameIdentifier.apply((String)"MuleAppConfigGenerator", (Option)Option.empty()));
            try (FileInputStream exchangeJsonStream = new FileInputStream(exchangeJsonFile);){
                File outputFile = new File(resourcesMuleDir, "config.yaml");
                ScriptingBindings bindings = new ScriptingBindings().addBinding(PAYLOAD, (Object)exchangeJsonStream, APPLICATION_JSON).addBinding("port", (Object)8081, APPLICATION_JAVA).addBinding("agentGW", (Object)"http://localhost:8081", APPLICATION_JAVA);
                configYaml.write(bindings, ServiceManager.apply(), Option.apply((Object)outputFile));
            }
            this.writeResource(LOG4J_CONFIG, new File(resourcesMuleDir, "log4j2.xml"));
            DataWeaveScript pomGenerator = this.dataWeaveScriptingEngine.compile(NameIdentifier.apply((String)"MuleAppPomGenerator", (Option)Option.empty()));
            try (FileInputStream exchangeJsonStream = new FileInputStream(exchangeJsonFile);){
                File pom = new File(outputDirectory, "pom.xml");
                ScriptingBindings bindings = new ScriptingBindings().addBinding(PAYLOAD, (Object)exchangeJsonStream, APPLICATION_JSON).addBinding("versions", versions, APPLICATION_JAVA);
                pomGenerator.write(bindings, ServiceManager.apply(), Option.apply((Object)pom));
            }
            this.writeResource(MULE_ARTIFACT_JSON, new File(outputDirectory, MULE_ARTIFACT_JSON));
            try (InputStream mvnw = this.getClass().getClassLoader().getResourceAsStream(MVNW);){
                assert (mvnw != null);
                file = new File(outputDirectory, MVNW);
                mvnwOut = new FileOutputStream(file);
                try {
                    ((OutputStream)mvnwOut).write(mvnw.readAllBytes());
                    file.setExecutable(true);
                }
                finally {
                    ((OutputStream)mvnwOut).close();
                }
            }
            try (InputStream mavenWrapper = this.getClass().getClassLoader().getResourceAsStream(MAVEN_WRAPPER_PROPERTIES);){
                assert (mavenWrapper != null);
                File parent = new File(outputDirectory, ".mvn" + File.separator + "wrapper");
                parent.mkdirs();
                File file2 = new File(parent, MAVEN_WRAPPER_PROPERTIES);
                try (FileOutputStream mvnwOut2 = new FileOutputStream(file2);){
                    ((OutputStream)mvnwOut2).write(mavenWrapper.readAllBytes());
                }
            }
            mvnw = this.getClass().getClassLoader().getResourceAsStream(MVNW_CMD);
            try {
                assert (mvnw != null);
                file = new File(outputDirectory, MVNW_CMD);
                mvnwOut = new FileOutputStream(file);
                try {
                    ((OutputStream)mvnwOut).write(mvnw.readAllBytes());
                    file.setExecutable(true);
                }
                finally {
                    ((OutputStream)mvnwOut).close();
                }
            }
            finally {
                if (mvnw != null) {
                    mvnw.close();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeResource(String resourcePath, File outputFile) throws Exception {
        try (InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(resourcePath);){
            assert (resourceAsStream != null);
            try (FileOutputStream outputStream = new FileOutputStream(outputFile);){
                ((OutputStream)outputStream).write(resourceAsStream.readAllBytes());
            }
        }
    }

    public static void main(String[] args) {
        MuleAppGenerator muleAppGenerator = new MuleAppGenerator();
        String command = args[0];
        if (!command.equalsIgnoreCase(GENERATE)) {
            throw new IllegalArgumentException("Usage: <generate> <mainFile> <exchangeJsonFile> <lowerEnv> <modulePath> <outputDirectory> <versions (name1=version1,name2=version2)>* ");
        }
        String versions = args.length == 7 ? args[6] : "";
        Map<String, String> versionMap = Arrays.stream(versions.split(",")).filter(s -> !s.isBlank()).collect(Collectors.toMap(v -> {
            String[] split = v.split("=");
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid version `" + v + "` it needs to be with the shape of name=version");
            }
            return split[0];
        }, v -> {
            String[] split = v.split("=");
            if (split.length != 2) {
                throw new IllegalArgumentException("Invalid version `" + v + "` it needs to be with the shape of name=version");
            }
            return split[1];
        }));
        muleAppGenerator.generateMuleApp(new File(args[1]), new File(args[2]), Boolean.parseBoolean(args[3]), args[4], new File(args[5]), versionMap);
        System.exit(0);
    }
}

