/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.compilation.serializer;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.Serializable;
import java.util.Stack;
import org.mule.weave.v2.compilation.ArraySerializableAstNode;
import org.mule.weave.v2.compilation.BooleanSerializableValueAstNode;
import org.mule.weave.v2.compilation.IntSerializableValueAstNode;
import org.mule.weave.v2.compilation.NodeSerializableAstNode;
import org.mule.weave.v2.compilation.NoneSerializableValueAstNode;
import org.mule.weave.v2.compilation.SerializableAstNode;
import org.mule.weave.v2.compilation.SerializableAstNodeKind$;
import org.mule.weave.v2.compilation.SerializableAstNodeLocation;
import org.mule.weave.v2.compilation.SerializableAstNodeLocation$;
import org.mule.weave.v2.compilation.StringSerializableValueAstNode;
import org.mule.weave.v2.compilation.exception.DeserializationException;
import org.mule.weave.v2.compilation.exception.IncompatibleBinarySerializationVersion;
import org.mule.weave.v2.compilation.exception.MissingBinarySerializationDeclaration;
import org.mule.weave.v2.version.DataWeaveRuntimeVersion$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SerializableAstNodeSerializer$ {
    public static SerializableAstNodeSerializer$ MODULE$;
    private final short[] binaryVersion;
    private final int DW_MAGIC_NUM;

    static {
        new SerializableAstNodeSerializer$();
    }

    private short[] binaryVersion() {
        return this.binaryVersion;
    }

    public int DW_MAGIC_NUM() {
        return this.DW_MAGIC_NUM;
    }

    public void serialize(SerializableAstNode astNode, DataOutputStream outputStream) {
        outputStream.writeInt(this.DW_MAGIC_NUM());
        outputStream.writeShort(BoxesRunTime.unboxToShort(new ArrayOps.ofShort(Predef$.MODULE$.shortArrayOps(this.binaryVersion())).head()));
        outputStream.writeShort(this.binaryVersion()[1]);
        this.doSerialize(astNode, outputStream);
    }

    private void doSerialize(SerializableAstNode astNode, DataOutputStream outputStream) {
        SerializableAstNode serializableAstNode = astNode;
        if (serializableAstNode instanceof NodeSerializableAstNode) {
            NodeSerializableAstNode nodeSerializableAstNode = (NodeSerializableAstNode)serializableAstNode;
            ((IterableLike)nodeSerializableAstNode.children().reverse()).foreach((Function1<SerializableAstNode, Object> & Serializable & scala.Serializable)child -> {
                SerializableAstNodeSerializer$.MODULE$.doSerialize(child, outputStream);
                return BoxedUnit.UNIT;
            });
            outputStream.writeShort(nodeSerializableAstNode.kind());
            outputStream.writeInt(nodeSerializableAstNode.children().length());
            outputStream.writeInt(astNode.location().startIndex());
            outputStream.writeInt(astNode.location().endIndex());
            return;
        }
        if (serializableAstNode instanceof ArraySerializableAstNode) {
            ArraySerializableAstNode arraySerializableAstNode = (ArraySerializableAstNode)serializableAstNode;
            ((IterableLike)arraySerializableAstNode.children().reverse()).foreach((Function1<SerializableAstNode, Object> & Serializable & scala.Serializable)child -> {
                SerializableAstNodeSerializer$.MODULE$.doSerialize(child, outputStream);
                return BoxedUnit.UNIT;
            });
            outputStream.writeShort(arraySerializableAstNode.kind());
            outputStream.writeInt(arraySerializableAstNode.children().length());
            return;
        }
        if (serializableAstNode instanceof StringSerializableValueAstNode) {
            StringSerializableValueAstNode stringSerializableValueAstNode = (StringSerializableValueAstNode)serializableAstNode;
            outputStream.writeShort(stringSerializableValueAstNode.kind());
            outputStream.writeUTF(stringSerializableValueAstNode.value());
            return;
        }
        if (serializableAstNode instanceof BooleanSerializableValueAstNode) {
            BooleanSerializableValueAstNode booleanSerializableValueAstNode = (BooleanSerializableValueAstNode)serializableAstNode;
            outputStream.writeShort(booleanSerializableValueAstNode.kind());
            outputStream.writeBoolean(booleanSerializableValueAstNode.value());
            return;
        }
        if (serializableAstNode instanceof IntSerializableValueAstNode) {
            IntSerializableValueAstNode intSerializableValueAstNode = (IntSerializableValueAstNode)serializableAstNode;
            outputStream.writeShort(intSerializableValueAstNode.kind());
            outputStream.writeInt(intSerializableValueAstNode.value());
            return;
        }
        if (serializableAstNode instanceof NoneSerializableValueAstNode) {
            outputStream.writeShort(astNode.kind());
            return;
        }
        throw new MatchError(serializableAstNode);
    }

    public SerializableAstNode deserialize(DataInputStream dataInputStream) {
        Stack<StringSerializableValueAstNode> stack = new Stack<StringSerializableValueAstNode>();
        this.validateBinaryHeader(dataInputStream);
        boolean eof = false;
        short kind = dataInputStream.readShort();
        while (!eof) {
            SerializableAstNode serializableAstNode;
            short s2 = kind;
            if (SerializableAstNodeKind$.MODULE$.STRING_VALUE_NODE() == s2) {
                String value = dataInputStream.readUTF();
                serializableAstNode = new StringSerializableValueAstNode(value);
            } else if (SerializableAstNodeKind$.MODULE$.BOOLEAN_VALUE_NODE() == s2) {
                boolean value = dataInputStream.readBoolean();
                serializableAstNode = new BooleanSerializableValueAstNode(value);
            } else if (SerializableAstNodeKind$.MODULE$.INT_VALUE_NODE() == s2) {
                int value = dataInputStream.readInt();
                serializableAstNode = new IntSerializableValueAstNode(value);
            } else if (SerializableAstNodeKind$.MODULE$.NONE_VALUE_NODE() == s2) {
                serializableAstNode = new NoneSerializableValueAstNode();
            } else if (SerializableAstNodeKind$.MODULE$.ARRAY_NODE() == s2) {
                int childrenCount = dataInputStream.readInt();
                serializableAstNode = new ArraySerializableAstNode(Predef$.MODULE$.wrapRefArray((Object[])SerializableAstNodeSerializer$.extract$1(childrenCount, stack)));
            } else {
                int childrenCount = dataInputStream.readInt();
                SerializableAstNodeLocation location = SerializableAstNodeLocation$.MODULE$.apply(dataInputStream.readInt(), dataInputStream.readInt());
                serializableAstNode = new NodeSerializableAstNode(kind, location, Predef$.MODULE$.wrapRefArray((Object[])SerializableAstNodeSerializer$.extract$1(childrenCount, stack)));
            }
            StringSerializableValueAstNode node = serializableAstNode;
            stack.push(node);
            try {
                kind = dataInputStream.readShort();
            }
            catch (EOFException eOFException) {
                eof = true;
            }
        }
        SerializableAstNode astNode = (SerializableAstNode)stack.pop();
        if (!stack.empty()) {
            throw new IllegalStateException("Parser stack not empty, orphan nodes remain");
        }
        return astNode;
    }

    private void validateBinaryHeader(DataInputStream dataInputStream) {
        int dwMagic = -1;
        short binaryMajor = -1;
        short binaryMinor = -1;
        try {
            dwMagic = dataInputStream.readInt();
            binaryMajor = dataInputStream.readShort();
            binaryMinor = dataInputStream.readShort();
        }
        catch (Throwable e) {
            throw new MissingBinarySerializationDeclaration(e);
        }
        if (dwMagic != this.DW_MAGIC_NUM()) {
            throw new DeserializationException("Corrupt bdwl header, couldn't find DW magic number");
        }
        if (binaryMajor != BoxesRunTime.unboxToShort(new ArrayOps.ofShort(Predef$.MODULE$.shortArrayOps(this.binaryVersion())).head()) || binaryMinor > this.binaryVersion()[1]) {
            throw new IncompatibleBinarySerializationVersion(binaryMajor, binaryMinor);
        }
    }

    public static final /* synthetic */ short $anonfun$binaryVersion$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toShort();
    }

    private static final SerializableAstNode[] extract$1(int count, Stack stack$1) {
        if (count <= 0) {
            return (SerializableAstNode[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(SerializableAstNode.class));
        }
        SerializableAstNode[] result = new SerializableAstNode[count];
        for (int i = 0; i < count; ++i) {
            if (stack$1.isEmpty()) {
                throw new IllegalStateException(new StringBuilder(65).append("Parser requested #").append(count).append(" elements but the stack has less nodes stacked.").toString());
            }
            result[i] = (SerializableAstNode)stack$1.pop();
        }
        return result;
    }

    private SerializableAstNodeSerializer$() {
        MODULE$ = this;
        this.binaryVersion = (short[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])DataWeaveRuntimeVersion$.MODULE$.binaryWeaveVersion().split("\\."))).map((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToShort(SerializableAstNodeSerializer$.$anonfun$binaryVersion$1(x$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Short()));
        this.DW_MAGIC_NUM = -629482886;
    }
}

