/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.model.values.coercion;

import java.io.Serializable;
import java.math.RoundingMode;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.Locale;
import org.mule.weave.v2.core.exception.UnsupportedBasePropertyException;
import org.mule.weave.v2.core.exception.UnsupportedTypeCoercionException;
import org.mule.weave.v2.core.exception.UnsupportedTypeCoercionException$;
import org.mule.weave.v2.core.exception.UnsupportedTypeCoercionToLiteralException$;
import org.mule.weave.v2.core.io.SeekableStream;
import org.mule.weave.v2.core.util.BinaryHelper$;
import org.mule.weave.v2.model.EvaluationContext;
import org.mule.weave.v2.model.structure.Namespace;
import org.mule.weave.v2.model.structure.QualifiedName;
import org.mule.weave.v2.model.structure.schema.Schema;
import org.mule.weave.v2.model.structure.schema.Schema$;
import org.mule.weave.v2.model.types.BinaryType$;
import org.mule.weave.v2.model.types.BooleanType$;
import org.mule.weave.v2.model.types.DateTimeType$;
import org.mule.weave.v2.model.types.KeyType$;
import org.mule.weave.v2.model.types.LocalDateTimeType$;
import org.mule.weave.v2.model.types.LocalDateType$;
import org.mule.weave.v2.model.types.LocalTimeType$;
import org.mule.weave.v2.model.types.NameType$;
import org.mule.weave.v2.model.types.NamespaceType$;
import org.mule.weave.v2.model.types.NumberType$;
import org.mule.weave.v2.model.types.PeriodType$;
import org.mule.weave.v2.model.types.RegexType$;
import org.mule.weave.v2.model.types.StringType$;
import org.mule.weave.v2.model.types.TimeType$;
import org.mule.weave.v2.model.types.TimeZoneType$;
import org.mule.weave.v2.model.types.Type;
import org.mule.weave.v2.model.types.TypeType$;
import org.mule.weave.v2.model.types.UriType$;
import org.mule.weave.v2.model.values.BinaryValue$;
import org.mule.weave.v2.model.values.CharSequenceValue$;
import org.mule.weave.v2.model.values.Value;
import org.mule.weave.v2.model.values.coercion.ValueCoercer;
import org.mule.weave.v2.model.values.math.Number;
import org.mule.weave.v2.parser.location.LocationCapable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001\u0002\u0007\u000e\u0001qA\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006\r\u0002!\te\u0012\u0005\u0006g\u0002!\t\u0001\u001e\u0005\b\u0003C\u0001A\u0011AA\u0012\u0011\u001d\ty\u0005\u0001C\u0001\u0003#Bq!!\u0016\u0001\t\u0003\t9\u0006C\u0004\u0002\u0004\u0002!\t!!\"\b\u000f\u00055U\u0002#\u0001\u0002\u0010\u001a1A\"\u0004E\u0001\u0003#CaA\u0011\u0006\u0005\u0002\u0005M%!D*ue&twmQ8fe\u000e,'O\u0003\u0002\u000f\u001f\u0005A1m\\3sG&|gN\u0003\u0002\u0011#\u00051a/\u00197vKNT!AE\n\u0002\u000b5|G-\u001a7\u000b\u0005Q)\u0012A\u0001<3\u0015\t1r#A\u0003xK\u00064XM\u0003\u0002\u00193\u0005!Q.\u001e7f\u0015\u0005Q\u0012aA8sO\u000e\u00011c\u0001\u0001\u001eGA\u0011a$I\u0007\u0002?)\t\u0001%A\u0003tG\u0006d\u0017-\u0003\u0002#?\t1\u0011I\\=SK\u001a\u00042\u0001J\u0013(\u001b\u0005i\u0011B\u0001\u0014\u000e\u000511\u0016\r\\;f\u0007>,'oY3s!\rA\u0013fK\u0007\u0002\u001f%\u0011!f\u0004\u0002\u0006-\u0006dW/\u001a\t\u0003YEj\u0011!\f\u0006\u0003]=\nA\u0001\\1oO*\t\u0001'\u0001\u0003kCZ\f\u0017B\u0001\u001a.\u00051\u0019\u0005.\u0019:TKF,XM\\2f\u0003\u00191\u0018\r\\;f'B\u0019a$N\u001c\n\u0005Yz\"AB(qi&|g\u000e\u0005\u00029\u007f9\u0011\u0011(\u0010\t\u0003u}i\u0011a\u000f\u0006\u0003ym\ta\u0001\u0010:p_Rt\u0014B\u0001  \u0003\u0019\u0001&/\u001a3fM&\u0011\u0001)\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005yz\u0012A\u0002\u001fj]&$h\b\u0006\u0002E\u000bB\u0011A\u0005\u0001\u0005\u0006g\t\u0001\r\u0001N\u0001\u0007G>,'oY3\u0015\t!{e,\u001b\u000b\u0003O%CQAS\u0002A\u0004-\u000b1a\u0019;y!\taU*D\u0001\u0012\u0013\tq\u0015CA\tFm\u0006dW/\u0019;j_:\u001cuN\u001c;fqRDQ\u0001U\u0002A\u0002E\u000bQA^1mk\u0016\u0004$AU+\u0011\u0007!J3\u000b\u0005\u0002U+2\u0001A!\u0003,P\u0003\u0003\u0005\tQ!\u0001X\u0005\ryF%M\t\u00031n\u0003\"AH-\n\u0005i{\"a\u0002(pi\"Lgn\u001a\t\u0003=qK!!X\u0010\u0003\u0007\u0005s\u0017\u0010C\u0003`\u0007\u0001\u0007\u0001-\u0001\u0007uCJ<W\r^*dQ\u0016l\u0017\rE\u0002\u001fk\u0005\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\rM\u001c\u0007.Z7b\u0015\t1\u0017#A\u0005tiJ,8\r^;sK&\u0011\u0001n\u0019\u0002\u0007'\u000eDW-\\1\t\u000b)\u001c\u0001\u0019A6\u0002\u001f1|7-\u0019;j_:\u001c\u0015\r]1cY\u0016\u0004\"\u0001\\9\u000e\u00035T!A\\8\u0002\u00111|7-\u0019;j_:T!\u0001]\n\u0002\rA\f'o]3s\u0013\t\u0011XNA\bM_\u000e\fG/[8o\u0007\u0006\u0004\u0018M\u00197f\u000391wN]7biR+W\u000e]8sC2$\"\"^<\u0002\u0002\u0005\r\u00111CA\u000b)\t9d\u000fC\u0003K\t\u0001\u000f1\nC\u0003y\t\u0001\u0007\u00110\u0001\u0005uK6\u0004xN]1m!\tQh0D\u0001|\u0015\tAHP\u0003\u0002~_\u0005!A/[7f\u0013\ty8P\u0001\tUK6\u0004xN]1m\u0003\u000e\u001cWm]:pe\")A\r\u0002a\u0001A\"9\u0011Q\u0001\u0003A\u0002\u0005\u001d\u0011AC:pkJ\u001cW\rV=qKB!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000eE\tQ\u0001^=qKNLA!!\u0005\u0002\f\t!A+\u001f9f\u0011\u0015QG\u00011\u0001l\u0011\u0019\u0001F\u00011\u0001\u0002\u0018A\"\u0011\u0011DA\u000f!\u0011A\u0013&a\u0007\u0011\u0007Q\u000bi\u0002B\u0006\u0002 \u0005U\u0011\u0011!A\u0001\u0006\u00039&aA0%e\u0005\u0001Bm\u001c$pe6\fG\u000fV3na>\u0014\u0018\r\u001c\u000b\u000f\u0003K\tI#a\u000b\u0002<\u0005}\u0012\u0011IA\")\r9\u0014q\u0005\u0005\u0006\u0015\u0016\u0001\u001da\u0013\u0005\u0006q\u0016\u0001\r!\u001f\u0005\b\u0003[)\u0001\u0019AA\u0018\u0003\u0019awnY1mKB!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026=\nA!\u001e;jY&!\u0011\u0011HA\u001a\u0005\u0019aunY1mK\"1\u0011QH\u0003A\u0002]\naAZ8s[\u0006$\bbBA\u0003\u000b\u0001\u0007\u0011q\u0001\u0005\u0006U\u0016\u0001\ra\u001b\u0005\u0007!\u0016\u0001\r!!\u00121\t\u0005\u001d\u00131\n\t\u0005Q%\nI\u0005E\u0002U\u0003\u0017\"1\"!\u0014\u0002D\u0005\u0005\t\u0011!B\u0001/\n\u0019q\fJ\u001a\u0002+\u0011,g-Y;mi\u001a{'/\\1u)\u0016l\u0007o\u001c:bYR\u0019q'a\u0015\t\u000ba4\u0001\u0019A=\u0002\u0019\u0019|'/\\1u\u001dVl'-\u001a:\u0015\u0015\u0005e\u0013\u0011MA9\u0003k\n9\b\u0006\u0003\u0002\\\u0005}\u0003c\u0001\u0017\u0002^%\u0011\u0001)\f\u0005\u0006\u0015\u001e\u0001\u001da\u0013\u0005\b\u0003G:\u0001\u0019AA3\u0003\u0005q\u0007\u0003BA4\u0003[j!!!\u001b\u000b\u0007\u0005-t\"\u0001\u0003nCRD\u0017\u0002BA8\u0003S\u0012aAT;nE\u0016\u0014\bBBA:\u000f\u0001\u0007\u0001-A\u0006nCf\u0014UmU2iK6\f\u0007\"\u00026\b\u0001\u0004Y\u0007B\u0002)\b\u0001\u0004\tI\b\r\u0003\u0002|\u0005}\u0004\u0003\u0002\u0015*\u0003{\u00022\u0001VA@\t-\t\t)a\u001e\u0002\u0002\u0003\u0005)\u0011A,\u0003\u0007}#C'\u0001\bok6\u0014WM\u001d+p'R\u0014\u0018N\\4\u0015\t\u0005\u001d\u00151\u0012\u000b\u0004o\u0005%\u0005\"\u0002&\t\u0001\bY\u0005bBA2\u0011\u0001\u0007\u0011QM\u0001\u000e'R\u0014\u0018N\\4D_\u0016\u00148-\u001a:\u0011\u0005\u0011R1C\u0001\u0006E)\t\ty\t")
public class StringCoercer
implements ValueCoercer<Value<CharSequence>> {
    private final Option<String> valueS;

    @Override
    public Option<Value<CharSequence>> coerceMaybe(Value<?> value, Option<Schema> targetSchema, LocationCapable locationCapable, EvaluationContext evaluationContext) {
        return ValueCoercer.coerceMaybe$(this, value, targetSchema, locationCapable, evaluationContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Value<CharSequence> coerce(Value<?> value, Option<Schema> targetSchema, LocationCapable locationCapable, EvaluationContext ctx) {
        CharSequence charSequence;
        Value<?> value2 = value;
        if (StringType$.MODULE$.accepts(value2, ctx)) {
            charSequence = (CharSequence)value.evaluate(ctx);
        } else if (DateTimeType$.MODULE$.accepts(value2, ctx)) {
            charSequence = this.formatTemporal((ZonedDateTime)value.evaluate(ctx), targetSchema, DateTimeType$.MODULE$, locationCapable, value, ctx);
        } else if (LocalDateTimeType$.MODULE$.accepts(value2, ctx)) {
            charSequence = this.formatTemporal((LocalDateTime)value.evaluate(ctx), targetSchema, LocalDateTimeType$.MODULE$, locationCapable, value, ctx);
        } else if (LocalTimeType$.MODULE$.accepts(value2, ctx)) {
            charSequence = this.formatTemporal((LocalTime)value.evaluate(ctx), targetSchema, LocalTimeType$.MODULE$, locationCapable, value, ctx);
        } else if (LocalDateType$.MODULE$.accepts(value2, ctx)) {
            charSequence = this.formatTemporal((LocalDate)value.evaluate(ctx), targetSchema, LocalDateType$.MODULE$, locationCapable, value, ctx);
        } else if (TimeType$.MODULE$.accepts(value2, ctx)) {
            charSequence = this.formatTemporal((OffsetTime)value.evaluate(ctx), targetSchema, TimeType$.MODULE$, locationCapable, value, ctx);
        } else if (PeriodType$.MODULE$.accepts(value2, ctx)) {
            charSequence = ((TemporalAmount)value.evaluate(ctx)).toString();
        } else if (TimeZoneType$.MODULE$.accepts(value2, ctx)) {
            charSequence = ((ZoneId)value.evaluate(ctx)).toString();
        } else if (NumberType$.MODULE$.accepts(value2, ctx)) {
            charSequence = this.formatNumber((Number)value.evaluate(ctx), targetSchema, locationCapable, value, ctx);
        } else if (BooleanType$.MODULE$.accepts(value2, ctx)) {
            charSequence = Boolean.toString(BoxesRunTime.unboxToBoolean(value.evaluate(ctx)));
        } else if (UriType$.MODULE$.accepts(value2, ctx)) {
            charSequence = ((URI)value.evaluate(ctx)).toString();
        } else if (BinaryType$.MODULE$.accepts(value2, ctx)) {
            Value binaryValue = BinaryType$.MODULE$.coerce(value, ctx);
            Option maybeBase = targetSchema.flatMap((Function1<Schema, Option> & Serializable & scala.Serializable)schema -> schema.base(ctx));
            if (maybeBase.isDefined()) {
                String base = (String)maybeBase.get();
                String string = base;
                if ("64".equals(string)) {
                    charSequence = BinaryHelper$.MODULE$.toBase64String((SeekableStream)binaryValue.evaluate(ctx), ctx.serviceManager().memoryService());
                } else {
                    if (!"16".equals(string)) throw new UnsupportedBasePropertyException(((LocationCapable)targetSchema.get().valueOf(Schema$.MODULE$.BASE_PROPERTY_NAME(), ctx).get()).location(), BinaryType$.MODULE$, StringType$.MODULE$, string, ctx);
                    byte[] content = BinaryValue$.MODULE$.getBytes(binaryValue, BinaryValue$.MODULE$.getBytes$default$2(), ctx);
                    charSequence = BinaryHelper$.MODULE$.toHexString(content);
                }
            } else {
                try {
                    Charset charset = (Charset)targetSchema.flatMap((Function1<Schema, Option> & Serializable & scala.Serializable)schema -> schema.encoding(ctx).map((Function1<String, Charset> & Serializable & scala.Serializable)x$1 -> Charset.forName(x$1))).getOrElse((Function0<Charset> & Serializable & scala.Serializable)() -> ctx.serviceManager().charsetProviderService().defaultCharset());
                    charSequence = BinaryValue$.MODULE$.toString((SeekableStream)binaryValue.evaluate(ctx), charset, ctx.serviceManager().memoryService(), BinaryValue$.MODULE$.toString$default$4());
                }
                catch (UnsupportedCharsetException e) {
                    throw new UnsupportedTypeCoercionException(locationCapable.location(), value.valueType(ctx), StringType$.MODULE$, (Function0<String> & Serializable & scala.Serializable)() -> "", new Some<String>(new StringBuilder(24).append("Unsupported Charset: `").append(e.getMessage()).append("`.").toString()), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$6(), ctx);
                }
                catch (IllegalCharsetNameException e) {
                    throw new UnsupportedTypeCoercionException(locationCapable.location(), value.valueType(ctx), StringType$.MODULE$, (Function0<String> & Serializable & scala.Serializable)() -> "", new Some<String>(new StringBuilder(19).append("Illegal Charset:`").append(e.getMessage()).append("`.").toString()), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$6(), ctx);
                }
                catch (Throwable e) {
                    throw new UnsupportedTypeCoercionException(locationCapable.location(), value.valueType(ctx), StringType$.MODULE$, (Function0<String> & Serializable & scala.Serializable)() -> "", new Some<String>(e.getMessage()), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$6(), ctx);
                }
            }
        } else if (NameType$.MODULE$.accepts(value2, ctx)) {
            charSequence = ((QualifiedName)value.evaluate(ctx)).name();
        } else if (TypeType$.MODULE$.accepts(value2, ctx)) {
            charSequence = ((Type)value.evaluate(ctx)).name();
        } else if (KeyType$.MODULE$.accepts(value2, ctx)) {
            charSequence = ((QualifiedName)value.evaluate(ctx)).name();
        } else if (RegexType$.MODULE$.accepts(value2, ctx)) {
            charSequence = ((Regex)value.evaluate(ctx)).toString();
        } else if (NamespaceType$.MODULE$.accepts(value2, ctx)) {
            charSequence = ((Namespace)value.evaluate(ctx)).uri();
        } else {
            Option<String> option = this.valueS;
            if (option instanceof Some) {
                Some some = (Some)option;
                String expectedString = (String)some.value();
                throw UnsupportedTypeCoercionToLiteralException$.MODULE$.apply(locationCapable.location(), value.valueType(ctx), StringType$.MODULE$, expectedString, value, ctx);
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            throw new UnsupportedTypeCoercionException(locationCapable.location(), value.valueType(ctx), StringType$.MODULE$, (Function0<String> & Serializable & scala.Serializable)() -> "", UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$5(), UnsupportedTypeCoercionException$.MODULE$.$lessinit$greater$default$6(), ctx);
        }
        CharSequence result = charSequence;
        Option<String> option = this.valueS;
        if (option instanceof Some) {
            Some some = (Some)option;
            String expectedString = (String)some.value();
            CharSequence charSequence2 = result;
            String string = expectedString;
            if (charSequence2 != null ? !charSequence2.equals(string) : string != null) throw UnsupportedTypeCoercionToLiteralException$.MODULE$.apply(locationCapable.location(), value.valueType(ctx), StringType$.MODULE$, expectedString, value, ctx);
            return CharSequenceValue$.MODULE$.apply(result, locationCapable, targetSchema);
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        return CharSequenceValue$.MODULE$.apply(result, locationCapable, targetSchema);
    }

    public String formatTemporal(TemporalAccessor temporal, Option<Schema> schema, Type sourceType, LocationCapable locationCapable, Value<?> value, EvaluationContext ctx) {
        Option formattedStringMaybe = schema.flatMap((Function1<Schema, Option> & Serializable & scala.Serializable)schemaValue -> schemaValue.format(ctx).map((Function1<String, String> & Serializable & scala.Serializable)format -> this.doFormatTemporal(temporal, (Locale)schemaValue.locale(ctx).map((Function1<String, Locale> & Serializable & scala.Serializable)localeString -> Locale.forLanguageTag(localeString)).getOrElse((Function0<Locale> & Serializable & scala.Serializable)() -> Locale.getDefault()), (String)format, sourceType, locationCapable, value, ctx)));
        return (String)formattedStringMaybe.getOrElse((Function0<String> & Serializable & scala.Serializable)() -> this.defaultFormatTemporal(temporal));
    }

    public String doFormatTemporal(TemporalAccessor temporal, Locale locale, String format, Type sourceType, LocationCapable locationCapable, Value<?> value, EvaluationContext ctx) {
        String string;
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format, locale);
            string = formatter.format(temporal);
        }
        catch (DateTimeException dte) {
            throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), sourceType, StringType$.MODULE$, value, Option$.MODULE$.apply(dte.getMessage()), ctx);
        }
        catch (IllegalArgumentException iae) {
            throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), sourceType, StringType$.MODULE$, value, Option$.MODULE$.apply(iae.getMessage()), ctx);
        }
        return string;
    }

    public String defaultFormatTemporal(TemporalAccessor temporal) {
        DateTimeFormatter dateTimeFormatter;
        TemporalAccessor temporalAccessor = temporal;
        if (temporalAccessor instanceof ZonedDateTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_OFFSET_DATE_TIME;
        } else if (temporalAccessor instanceof LocalDateTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        } else if (temporalAccessor instanceof LocalTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_TIME;
        } else if (temporalAccessor instanceof LocalDate) {
            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE;
        } else if (temporalAccessor instanceof OffsetTime) {
            dateTimeFormatter = DateTimeFormatter.ISO_TIME;
        } else {
            throw new MatchError(temporalAccessor);
        }
        DateTimeFormatter formatter = dateTimeFormatter;
        return formatter.format(temporal);
    }

    public String formatNumber(Number n, Option<Schema> mayBeSchema, LocationCapable locationCapable, Value<?> value2, EvaluationContext ctx) {
        Option<Schema> option = mayBeSchema;
        if (option instanceof Some) {
            Some some = (Some)option;
            Schema schema = (Schema)some.value();
            Schema schemaValue = schema;
            Option<String> option2 = schemaValue.format(ctx);
            if (option2 instanceof Some) {
                String string;
                Some some2 = (Some)option2;
                String f = (String)some2.value();
                try {
                    DecimalFormatSymbols formatSymbols = (DecimalFormatSymbols)schemaValue.locale(ctx).map((Function1<String, DecimalFormatSymbols> & Serializable & scala.Serializable)locale -> DecimalFormatSymbols.getInstance(Locale.forLanguageTag(locale))).getOrElse((Function0<DecimalFormatSymbols> & Serializable & scala.Serializable)() -> DecimalFormatSymbols.getInstance(Locale.getDefault(Locale.Category.FORMAT)));
                    DecimalFormat formatter = new DecimalFormat(f, formatSymbols);
                    RoundingMode halfup = (RoundingMode)((Object)schemaValue.roundMode(ctx).flatMap((Function1<String, Option> & Serializable & scala.Serializable)value -> Try$.MODULE$.apply((Function0<RoundingMode> & Serializable & scala.Serializable)() -> RoundingMode.valueOf(value)).toOption()).getOrElse((Function0<RoundingMode> & Serializable & scala.Serializable)() -> RoundingMode.HALF_UP));
                    formatter.setRoundingMode(halfup);
                    formatter.setParseBigDecimal(true);
                    string = formatter.format(n.toBigDecimal().bigDecimal());
                }
                catch (IllegalArgumentException iae) {
                    throw UnsupportedTypeCoercionException$.MODULE$.apply(locationCapable.location(), NumberType$.MODULE$, StringType$.MODULE$, value2, Option$.MODULE$.apply(iae.getMessage()), ctx);
                }
                return string;
            }
            return this.numberToString(n, ctx);
        }
        return this.numberToString(n, ctx);
    }

    public String numberToString(Number n, EvaluationContext ctx) {
        if (ctx.serviceManager().settingsService().execution().stripTrailingZeroes()) {
            return n.toCanonicalString(ctx);
        }
        if (n.isWhole()) {
            String string;
            if (n.withinInt()) {
                return Integer.toString(n.toInt());
            }
            if (n.withinLong()) {
                return Long.toString(n.toLong());
            }
            try {
                string = n.toBigInt().toString();
            }
            catch (ArithmeticException arithmeticException) {
                string = n.toString();
            }
            return string;
        }
        return n.toString();
    }

    public StringCoercer(Option<String> valueS) {
        this.valueS = valueS;
        ValueCoercer.$init$(this);
    }
}

