/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.agent;

import org.mule.runtime.api.healthcheck.HealthCheckValidator;

/**
 * Runtime HealthCheck service to be used by Mule Agent
 */
public interface HealthCheck {

  /**
   * Checks if all GateKeeper handled APIs are unblocked
   *
   * @return true if all current APIs are unblocked
   */
  boolean isInstanceTrafficAllowed();

  /**
   * Checks if all GateKeeper handled APIs belonging to a given application
   *  are unblocked
   *
   * @param applicationName
   * @return true if all the application APIs are unblocked
   */
  boolean isApplicationTrafficAllowed(String applicationName);

  /**
   * Adapter for Mule API health check validator interface by application
   *
   * @param applicationName application to check health status
   * @return a validator instance for a particular application
   */
  HealthCheckValidator getValidator(String applicationName);

  /**
   * Adapter for Mule API health check validator interface by API
   *
   * @param apiId API to check health status
   * @return a validator instance for a particular API
   */
  HealthCheckValidator getApiValidator(Long apiId);
}
