/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.analytics;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;

/**
 * Analytics's status of a particular flow
 */
public class AnalyticsStatus {

  private final Status status;
  private final String appName;
  private final String flowName;
  private final ApiKey apiKey;

  public AnalyticsStatus(Status status, String appName, String flowName, ApiKey apiKey) {
    this.status = status;
    this.appName = appName;
    this.flowName = flowName;
    this.apiKey = apiKey;
  }

  /**
   * @return {@link Status} of the flow
   */
  public Status status() {
    return status;
  }

  /**
   * @return Name of the application which owns the flow
   */
  public String appName() {
    return appName;
  }

  /**
   * @return Name of the flow
   */
  public String flowName() {
    return flowName;
  }

  /**
   * @return an {@link ApiKey} of the API implemented by the flow or null if no API is implemented in it
   */
  public ApiKey apiKey() {
    return apiKey;
  }

  public enum Status {

    /**
     * An {@link AnalyticsHttpEvent} is generated whenever the flow is executed
     */
    ENABLED,

    /**
     * No {@link AnalyticsHttpEvent} is generated whenever the flow is executed
     */
    DISABLED
  }
}
