/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.config;

import static com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration.Mode.DISABLED;
import static com.mulesoft.mule.runtime.gw.api.config.GateKeeperConfiguration.Mode.FLEXIBLE;
import static org.apache.commons.lang3.StringUtils.trimToNull;

public class GateKeeperConfiguration extends RuntimeConfiguration {

  /**
   * Blocks traffic to tracked APIs until all policies retrieved from platform are applied successfully.
   * Default is true (in flexible mode).
   */
  private static final String GATEKEEPER_MODE = "anypoint.platform.gatekeeper";
  private static final String GATEKEEPER_MODE_DEFAULT = FLEXIBLE.name();

  public boolean isEnabled() {
    return !parsePropertyValue().equals(DISABLED);
  }

  public Mode mode() {
    return parsePropertyValue();
  }

  private Mode parsePropertyValue() {
    String modeInput = trimToNull(System.getProperty(GATEKEEPER_MODE, GATEKEEPER_MODE_DEFAULT));

    try {
      return Mode.valueOf(modeInput.toUpperCase());
    } catch (IllegalArgumentException e) {
      LOGGER.warn("{} is not a valid GateKeeper configuration mode. Flexible mode will be used", modeInput);
      return FLEXIBLE;
    }
  }

  public enum Mode {
    DISABLED, FLEXIBLE, STRICT
  }
}
