/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.config;

public class GatewayConfiguration {

  private ExternalAuthConfiguration externalAuthConfiguration = new ExternalAuthConfiguration();
  private GateKeeperConfiguration gateKeeperConfiguration = new GateKeeperConfiguration();
  private GatewaySecurityConfiguration policyEncryptionConfiguration = new GatewaySecurityConfiguration();
  private OnApiDeletedConfiguration onApiDeletedConfiguration = new OnApiDeletedConfiguration(gateKeeperConfiguration);
  private PlatformClientConfiguration platformClientConfiguration = new PlatformClientConfiguration();
  private ProxyConfiguration proxyConfiguration = new ProxyConfiguration();
  private ThrottlingConfiguration throttlingConfiguration = new ThrottlingConfiguration();
  private MetricsConfiguration metricsConfiguration = new MetricsConfiguration();

  public ProxyConfiguration proxy() {
    return proxyConfiguration;
  }

  public ExternalAuthConfiguration externalAuth() {
    return externalAuthConfiguration;
  }

  public ThrottlingConfiguration throttling() {
    return throttlingConfiguration;
  }

  public PlatformClientConfiguration platformClient() {
    return platformClientConfiguration;
  }

  public GateKeeperConfiguration gateKeeper() {
    return gateKeeperConfiguration;
  }

  public GatewaySecurityConfiguration securityConfiguration() {
    return policyEncryptionConfiguration;
  }

  public OnApiDeletedConfiguration onApiDeletedConfiguration() {
    return onApiDeletedConfiguration;
  }

  public MetricsConfiguration metrics() {
    return metricsConfiguration;
  }
}
