/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.functional;

import static java.util.stream.Collectors.toMap;

import java.util.Map;
import java.util.Map.Entry;
import java.util.function.Function;
import java.util.stream.Collector;

public class StreamsInMaps {

  /**
   * Function to be used when streaming maps just to convert the value of the entries.
   * <p>
   * Example: "I would like to have a new map with the age of every person, but preserving the same keys".
   * Lets suppose the key is a {@link String}, the conversion would be: {@code Map<String, Person> --> Map<String, Integer>}.
   * <p>
   * The code would look something like this (let 'persons' be the map):
   * <p>
   * {@code Map<String, Integer> ages = persons.entrySet().stream().collect(mapWithValues(e -> e.getValue().age()));}
   *
   * @param valueMapper value conversion function.
   * @param <K>         key type.
   * @param <V1>        original map's value type to convert.
   * @param <V2>        resulting map's value type after conversion.
   * @return The {@link Collector} of the {@link Map}.
   */
  public static <K, V1, V2> Collector<Entry<K, V1>, ?, Map<K, V2>> mapWithValues(Function<Entry<K, V1>, V2> valueMapper) {
    return toMap(
                 e -> e.getKey(),
                 valueMapper);
  }
}
