/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.time.clock;

import com.mulesoft.mule.runtime.gw.api.time.DateTime;

/**
 * Defines a clock where time only moves forward programmatically
 */
public class ManualClock extends Clock {

  private static final long serialVersionUID = -561637225111662764L;
  private DateTime now;

  public ManualClock(long dateTimeInMillis) {
    this(new DateTime(dateTimeInMillis));
  }

  public ManualClock(DateTime now) {
    this.now = now;
  }

  @Override
  public DateTime currentTime() {
    return this.now;
  }

  public ManualClock moveForwardMillis(long millis) {
    this.now = this.now.plusMillis((int) millis);
    return this;
  }
}
