/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.not;

import com.mulesoft.mule.runtime.gw.api.contract.InvalidAPIException;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ApiKeyTestCase {

  @Rule
  public ExpectedException thrown = ExpectedException.none();

  @Test
  public void cannotCreateAPIWithNoId() {
    thrown.expect(InvalidAPIException.class);
    thrown.expectMessage("Api id cannot be null");
    new ApiKey(null);
  }

  @Test
  public void equalsByProperty() {
    assertThat(new ApiKey(1L), is(new ApiKey(1L)));
    assertThat(new ApiKey(1L), not(new ApiKey(2L)));
    assertThat(new ApiKey(1L), not(new ApiKey(3L)));
  }
}
