/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.expirable.mock;

import org.mule.runtime.api.store.ObjectAlreadyExistsException;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;

import com.mulesoft.mule.runtime.gw.api.expirable.exception.ExpirableObjectMessage;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InMemoryObjectStore<T extends Serializable> implements ObjectStore<T> {

  Map<String, T> memory = new HashMap<>();

  @Override
  public boolean contains(String key) throws ObjectStoreException {
    return memory.containsKey(key);
  }

  @Override
  public void store(String key, T value) throws ObjectStoreException {
    if (memory.containsKey(key)) {
      throw new ObjectAlreadyExistsException(new ExpirableObjectMessage("pam panana, pana, nana, can't touch this."));
    }
    memory.put(key, value);
  }

  @Override
  public T retrieve(String key) throws ObjectStoreException {
    return memory.get(key);
  }

  @Override
  public T remove(String key) throws ObjectStoreException {
    return memory.remove(key);
  }

  @Override
  public boolean isPersistent() {
    return false;
  }

  @Override
  public void clear() throws ObjectStoreException {
    memory.clear();
  }

  @Override
  public void open() throws ObjectStoreException { //TODO

  }

  @Override
  public void close() throws ObjectStoreException { //TODO

  }

  @Override
  public List<String> allKeys() throws ObjectStoreException { //TODO
    return new ArrayList<>(memory.keySet());
  }

  @Override
  public Map<String, T> retrieveAll() throws ObjectStoreException { //TODO
    return memory;
  }
}
