/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.config;

import static com.mulesoft.mule.runtime.gw.api.time.period.Period.millis;
import static org.junit.Assert.assertEquals;

import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.api.config.PlatformClientConfiguration;
import com.mulesoft.mule.runtime.gw.api.config.PlatformUnauthenticatedClientConfiguration;
import org.junit.After;
import org.junit.Test;

public class PlatformUnauthenticatedClientConfigurationTestCase {

  private PlatformClientConfiguration configuration = new PlatformUnauthenticatedClientConfiguration();

  @After
  public void tearDown() {
    System.clearProperty("anypoint.platform.templates_read_timeout");
  }

  @Test
  public void readTimeoutDefault() {
    assertEquals(configuration.getReadTimeout(), millis(60000));
  }

  @Test
  public void readTimeoutCustom() {
    System.setProperty("anypoint.platform.templates_read_timeout", "120000");
    assertEquals(configuration.getReadTimeout(), millis(120000));
  }

  @Test
  public void readTimeoutCustomForever() {
    System.setProperty("anypoint.platform.templates_read_timeout", "0");
    assertEquals(configuration.getReadTimeout(), millis(0));
  }

  @Test
  public void readTimeoutInvalid() {
    System.setProperty("anypoint.platform.templates_read_timeout", "alpha");
    assertEquals(configuration.getReadTimeout(), millis(60000));
    System.setProperty("anypoint.platform.templates_read_timeout", "-1000");
    assertEquals(configuration.getReadTimeout(), millis(60000));
  }

}
