/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.contract;

import static java.util.Collections.emptyList;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;

import com.mulesoft.mule.runtime.gw.api.ApiContracts;
import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.exception.ForbiddenClientException;

import java.util.List;

import org.junit.Test;

public class ApiContractsDefaultsTestCase {

  @Test
  public void checkDefaults() {
    new ApiContractsImpl().dispose();
    assertThat(new ApiContractsImpl().contracts(), is(emptyList()));
  }

  class ApiContractsImpl implements ApiContracts {

    @Override
    public ApiContracts updateContracts(List<Contract> contracts) {
      return null;
    }

    @Override
    public ApiContracts updateContracts(Contract... contracts) {
      return null;
    }

    @Override
    public Sla sla(Client client) throws ForbiddenClientException {
      return null;
    }

    @Override
    public Sla sla(String clientId) throws ForbiddenClientException {
      return null;
    }

    @Override
    public Client validate(String clientId, String clientSecret) throws ForbiddenClientException {
      return null;
    }

    @Override
    public Client validate(String clientId) throws ForbiddenClientException {
      return null;
    }
  }
}
