/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.contract;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.NoSla;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ContractBuilderTestCase {

  @Rule
  public ExpectedException thrown = ExpectedException.none();

  @Test
  public void cannotCreateContractWithoutClient() {
    thrown.expectMessage("Cannot create Contract without a Client");
    Contract.builder().withSla(new NoSla()).build();
  }

  @Test
  public void cannotCreateContractWithNullClient() {
    thrown.expectMessage("Cannot create Contract without a Client");
    Contract.builder().withSla(new NoSla()).withClient(null).build();
  }

  @Test
  public void cannotCreateContractWithNullSLA() {
    thrown.expectMessage("Cannot create Contract without an SLA");
    Client client = Client.builder().withId("id").withSecret("secret").withName("some name").build();
    Contract.builder().withClient(client).withSla(null).build();
  }

  @Test
  public void defaultSlaIsNoSla() {
    Client client = Client.builder().withId("id").withSecret("secret").withName("some name").build();
    Contract contract = Contract.builder().withClient(client).build();
    assertThat(contract.sla(), is(new NoSla()));
  }
}
