/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.exception;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import com.mulesoft.mule.runtime.gw.api.exception.ForbiddenClientException;

import org.junit.Test;

public class ForbiddenClientExceptionTestCase {

  @Test
  public void validMessage() {
    String errorMessage = "my boring description";
    assertThat(new ForbiddenClientException(errorMessage).getMessage(), is(errorMessage));
  }

  @Test
  public void nullMessage() {
    assertThat(new ForbiddenClientException(null).getMessage(), is("null"));
  }

}
