/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.api.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RuntimeConfiguration {
    static final Logger LOGGER = LoggerFactory.getLogger(RuntimeConfiguration.class);

    protected int parseIntOrDefault(String propertyName, int defaultValue) {
        String property = null;
        try {
            property = System.getProperty(propertyName);
            return property != null ? Integer.parseInt(property) : defaultValue;
        }
        catch (NumberFormatException e) {
            LOGGER.warn("{} is not a valid integer. {} will be used for {}", new Object[]{property, defaultValue, propertyName});
            return defaultValue;
        }
    }

    protected int parsePositive0IntOrDefault(String propertyName, int defaultValue) {
        int value = this.parseIntOrDefault(propertyName, defaultValue);
        if (value < 0) {
            LOGGER.warn("{} is a negative integer. {} will be used for {}", new Object[]{value, defaultValue, propertyName});
            value = defaultValue;
        }
        return value;
    }

    protected long parseLongOrDefault(String propertyName, long defaultValue) {
        String property = null;
        try {
            property = System.getProperty(propertyName);
            return property != null ? Long.parseLong(property) : defaultValue;
        }
        catch (NumberFormatException e) {
            LOGGER.warn("{} is not a valid integer. {} will be used for {}", new Object[]{property, defaultValue, propertyName});
            return defaultValue;
        }
    }
}

