/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.config;

import static org.apache.commons.lang3.StringUtils.trimToNull;

public class ExternalAuthConfiguration extends RuntimeConfiguration {

  /**
   * Enable Federate policies to use the Gateway proxy settings. By default it's false.
   */
  private static final String EXTERNAL_AUTH_PROVIDER_ENABLE_PROXY =
      "anypoint.platform.external_authentication_provider_enable_proxy_settings";

  /**
   * Cache capacity of the oauth2 external provider authentication token . Default is 100000.
   */
  private static final String OAUTH_CACHE_MAX_SIZE_PROPERTY_NAME = "anypoint.platform.oauth2_cache_max_size";

  /**
   * Cache capacity of the Open AM external provider authentication token . Default is 100000.
   */
  private static final String OPEN_AM_CACHE_MAX_SIZE_PROPERTY_NAME = "anypoint.platform.open_am_cache_max_size";

  /**
   * Cache capacity of the Open ID external provider authentication token . Default is 100000.
   */
  private static final String OPEN_ID_CACHE_MAX_SIZE_PROPERTY_NAME = "anypoint.platform.openid_connect_cache_max_size";

  /**
   * Cache capacity of the Ping Federate external provider authentication token . Default is 100000.
   */
  private static final String PF_CACHE_MAX_SIZE_PROPERY_NAME = "anypoint.platform.ping_federate_cache_max_size";

  private static final long CACHE_MAX_SIZE_DEFAULT = 10000;

  ExternalAuthConfiguration() {}

  public boolean isProxyEnabled() {
    return Boolean.valueOf(trimToNull(System.getProperty(EXTERNAL_AUTH_PROVIDER_ENABLE_PROXY, "false")));
  }

  public long getOauthCacheMaxSize() {
    return parseLongOrDefault(OAUTH_CACHE_MAX_SIZE_PROPERTY_NAME, CACHE_MAX_SIZE_DEFAULT);
  }

  public long getOpenAmCacheMaxSize() {
    return parseLongOrDefault(OPEN_AM_CACHE_MAX_SIZE_PROPERTY_NAME, CACHE_MAX_SIZE_DEFAULT);
  }

  public long getPingFederateCacheMaxSize() {
    return parseLongOrDefault(PF_CACHE_MAX_SIZE_PROPERY_NAME, CACHE_MAX_SIZE_DEFAULT);
  }

  public long getOpenIdCacheMaxSize() {
    return parseLongOrDefault(OPEN_ID_CACHE_MAX_SIZE_PROPERTY_NAME, CACHE_MAX_SIZE_DEFAULT);
  }
}
