/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.internal.client;

import com.mulesoft.mule.runtime.gw.api.client.CoreServicesClient;

import java.util.Set;

public class ValidCoreServicesClient extends CoreServicesClient {

  private static final long serialVersionUID = 8590346881598032663L;
  private final String id;
  private final String secret;
  private final String name;
  private final Set<String> redirectionUris;

  public ValidCoreServicesClient(String id, String secret, String name, Set<String> redirectionUris) {
    this.id = id;
    this.secret = secret;
    this.name = name;
    this.redirectionUris = redirectionUris;
  }

  @Override
  public String id() {
    return id;
  }

  @Override
  public String secret() {
    return secret;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public Set<String> redirectionUris() {
    return redirectionUris;
  }

  @Override
  public String toString() {
    return "ValidCoreServicesClient{" + super.toString() + '}';
  }
}
