/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.time;

import static com.mulesoft.mule.runtime.gw.api.time.period.Period.millis;
import static com.mulesoft.mule.runtime.gw.api.time.period.Period.seconds;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.not;

import org.junit.Test;

public class PeriodTestCase {

  @Test
  public void secondsEquality() {
    assertThat(seconds(2), is(seconds(2)));
    assertThat(seconds(10), not(seconds(3)));
    assertThat(seconds(0), is(seconds(0)));
  }

  @Test
  public void millisEquality() {
    assertThat(millis(2), is(millis(2)));
    assertThat(millis(2), not(millis(666)));
    assertThat(millis(0), is(millis(0)));
  }

  @Test
  public void secondsAndMillis() {
    assertThat(seconds(2), is(millis(2000)));
    assertThat(millis(2000), is(seconds(2)));
    assertThat(millis(2), not(seconds(2)));
    assertThat(seconds(2), not(millis(2)));
  }

  @Test
  public void inMillisMethod() {
    assertThat(seconds(2).inMillis(), is(2000L));
    assertThat(millis(2000).inMillis(), is(2000L));
  }

  @Test
  public void inSecondsMethod() {
    assertThat(seconds(2).inSeconds(), is(2L));
    assertThat(millis(1499).inSeconds(), is(1L));
    assertThat(millis(1500).inSeconds(), is(2L));
    assertThat(millis(1700).inSeconds(), is(2L));
  }

  @Test
  public void inLongSecondsMethod() {
    assertThat(seconds(2L).inSeconds(), is(2L));
  }
}
