/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.time;

import static com.mulesoft.mule.runtime.gw.api.time.period.Period.millis;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import com.mulesoft.mule.runtime.gw.api.time.DateTime;
import com.mulesoft.mule.runtime.gw.api.time.clock.Clock;
import com.mulesoft.mule.runtime.gw.api.time.clock.ManualClock;
import com.mulesoft.mule.runtime.gw.api.time.frame.TimeFrame;
import com.mulesoft.mule.runtime.gw.internal.time.frame.FixedTimeFrame;
import com.mulesoft.mule.runtime.gw.internal.time.frame.FixedTimeFrameFactory;

import org.junit.Test;

public class TimeFrameTestCase {

  @Test
  public void createFixed() {
    DateTime now = DateTime.now();
    Clock clock = new ManualClock(now);
    TimeFrame timeFrame = new FixedTimeFrameFactory(clock, now).createWith(millis(100));

    assertThat(timeFrame, is(new FixedTimeFrame(clock, now, millis(100))));
  }

  @Test
  public void createCurrentWithinSameWindow() {
    DateTime now = DateTime.now();
    Clock clock = new ManualClock(now);
    TimeFrame timeFrame = new FixedTimeFrameFactory(clock, now).createCurrentWith(millis(100));

    assertThat(timeFrame, is(new FixedTimeFrame(clock, now, millis(100))));
  }

  @Test
  public void createCurrentWhenExpiredWindow() {

    DateTime now = DateTime.now();
    Clock clock = new ManualClock(now).moveForwardMillis(101);
    TimeFrame timeFrame = new FixedTimeFrameFactory(clock, now).createCurrentWith(millis(100));

    assertThat(timeFrame, is(new FixedTimeFrame(clock, now.plus(100), millis(100))));
  }
}
