/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.config;

import static com.mulesoft.mule.runtime.gw.api.config.OnApiDeletedConfiguration.Mode.BLOCK_API;
import static com.mulesoft.mule.runtime.gw.api.config.OnApiDeletedConfiguration.Mode.KEEP_POLICIES;
import static org.apache.commons.lang3.StringUtils.trimToNull;

public class OnApiDeletedConfiguration extends RuntimeConfiguration {

  /**
   * Strategy to execute when an API is detected as deleted in API Manager. Current strategies are to keep policies in the current
   * state or block the API using GateKeeper
   */
  private static final String ON_API_DELETED = "anypoint.platform.policies.on_api_deleted";
  private static final Mode ON_API_DELETED_DEFAULT_VALUE = KEEP_POLICIES;

  private final GateKeeperConfiguration gateKeeperConfiguration;

  public OnApiDeletedConfiguration(GateKeeperConfiguration gateKeeperConfiguration) {
    this.gateKeeperConfiguration = gateKeeperConfiguration;
  }

  public boolean shouldBlock() {
    return gateKeeperConfiguration.isEnabled() && parsePropertyValue().equals(BLOCK_API);
  }

  private Mode parsePropertyValue() {
    String modeInput = trimToNull(System.getProperty(ON_API_DELETED, ON_API_DELETED_DEFAULT_VALUE.name()));

    try {
      return Mode.valueOf(modeInput.toUpperCase());
    } catch (IllegalArgumentException e) {
      LOGGER.warn("{} is not a valid configuration mode. Policies will be kept upon API deletion on API Platform", modeInput);
      return KEEP_POLICIES;
    }
  }

  public enum Mode {
    KEEP_POLICIES, BLOCK_API;
  }
}
