/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.client;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;

import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.internal.client.ValidClient;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ClientBuilderTestCase {

  @Rule
  public ExpectedException thrown = ExpectedException.none();

  @Test
  public void createClient() {

    assertThat(Client.builder().withId("id").withSecret("secret").withName("name").build(),
               is(new ValidClient("id", "secret", "name")));
  }

  @Test
  public void cannotCreateClientWithoutId() {
    thrown.expectMessage("Cannot create a Client without its ID");

    Client.builder().withSecret("some secret").build();
  }

  @Test
  public void cannotCreateClientWithoutSecret() {
    thrown.expectMessage("Cannot create a Client without its Secret");

    Client.builder().withId("id").build();
  }
}
