/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.config;

import static java.lang.System.setProperty;
import static java.util.Arrays.asList;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.api.config.MetricsConfiguration;

import java.util.List;

import org.junit.After;
import org.junit.Test;

public class MetricsConfigurationTestCase {

  private MetricsConfiguration configuration = new GatewayConfiguration().metrics();

  private List<String> systemProperties = asList("anypoint.platform.metrics_enabled",
                                                 "anypoint.platform.metrics_attempts",
                                                 "anypoint.platform.metrics_capacity",
                                                 "anypoint.platform.metrics_push_freq",
                                                 "anypoint.platform.metrics_status_freq");

  @After
  public void tearDown() {
    systemProperties.forEach(System::clearProperty);
  }

  @Test
  public void metricsEnabledDefault() {
    assertThat(configuration.metricsEnabled(), is(true));
  }

  @Test
  public void metricsEnabled() {
    setProperty("anypoint.platform.metrics_enabled", "true");
    assertThat(configuration.metricsEnabled(), is(true));
  }

  @Test
  public void metricsDisabled() {
    setProperty("anypoint.platform.metrics_enabled", "false");
    assertThat(configuration.metricsEnabled(), is(false));
  }

  @Test
  public void metricsPushEventsDefault() {
    assertThat(configuration.getMetricsPushEventsFrequency(), is(600));
  }

  @Test
  public void metricsPushEvents() {
    setProperty("anypoint.platform.metrics_push_freq", "666");
    assertThat(configuration.getMetricsPushEventsFrequency(), is(666));
  }

  @Test
  public void metricsCapacityDefault() {
    assertThat(configuration.getMetricsCapacity(), is(3000));
  }

  @Test
  public void metricsCapacity() {
    setProperty("anypoint.platform.metrics_capacity", "200");
    assertThat(configuration.getMetricsCapacity(), is(200));
  }

  @Test
  public void metricsFrequencyDefault() {
    assertThat(configuration.getMetricsStatusFrequency(), is(24 * 60 * 60));
  }

  @Test
  public void metricsFrequency() {
    setProperty("anypoint.platform.metrics_status_freq", "200");
    assertThat(configuration.getMetricsStatusFrequency(), is(200));
  }

}
