/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.analytics;

import java.io.Serializable;

public class PolicyViolation implements Serializable {

  private static final long serialVersionUID = 8534847122766209496L;

  /**
   * Identifier of the policy that was violated
   */
  private String policyId;

  /**
   * {@link PolicyViolationOutcome} of the policy execution
   */
  private PolicyViolationOutcome outcome;

  /**
   * Name of the policy's that was violated name
   */
  private String policyName;

  private String category;

  private PolicyViolation() {}

  public static Builder builder() {
    return new Builder();
  }

  public String getPolicyId() {
    return policyId;
  }

  public PolicyViolationOutcome getOutcome() {
    return outcome;
  }

  public String getPolicyName() {
    return this.policyName;
  }

  public String getCategory() {
    return this.category;
  }

  @Override
  public String toString() {
    return "{" + "outcome=" + outcome + ", policyId=" + policyId + '}';
  }

  public static class Builder {

    private final PolicyViolation violation;

    public Builder() {
      violation = new PolicyViolation();
    }

    public Builder withPolicyId(String policyId) {
      violation.policyId = policyId;
      return this;
    }

    public Builder withOutcome(PolicyViolationOutcome outcome) {
      violation.outcome = outcome;
      return this;
    }

    public Builder withCategory(String category) {
      violation.category = category;
      return this;
    }

    public Builder withPolicyName(String policyName) {
      violation.policyName = policyName;
      return this;
    }

    public PolicyViolation build() {
      return violation;
    }
  }

}
