/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.client;

/**
 * Repository providing {@link Client Clients} defined in API Platform.
 */
public interface ClientsRepository {

  /**
   * Retrieves {@link Client Clients} defined in API Platform by an id. Each implementation may choose to implement an
   * optimization algorithm to avoid subsequent calls or fallback mechanisms for when Platform is down.
   *
   * @param id a {@link String}.
   * @return the matching {@link Client} or raise an error if it could not be found.
   * @throws ClientsRepositoryException whenever the {@link Client} is not found or a connectivity error arises.
   */
  CoreServicesClient getBy(String id) throws ClientsRepositoryException;

  /**
   * Retrieves {@link Client Clients} defined in API Platform by id and secret. Each implementation may choose to implement an
   * optimization algorithm to avoid subsequent calls or fallback mechanisms for when Platform is down.
   *
   * @param id a {@link String}.
   * @param secret a {@link String}.
   * @return the matching {@link Client} or raise an error if it could not be found.
   * @throws ClientsRepositoryException whenever the {@link Client} is not found or a connectivity error arises.
   */
  CoreServicesClient getBy(String id, String secret) throws ClientsRepositoryException;

}
