/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.config;


import static com.mulesoft.mule.runtime.gw.api.time.period.Period.millis;

import com.mulesoft.mule.runtime.gw.api.time.period.Period;

public class PlatformUnauthenticatedClientConfiguration extends PlatformClientConfiguration {

  /**
   * http policy templates client read timeout in milliseconds
   */
  private static final String TEMPLATES_READ_TIMEOUT = "anypoint.platform.templates_read_timeout";
  public static final int TEMPLATES_READ_TIMEOUT_DEFAULT = 60000;


  @Override
  public Period getReadTimeout() {
    return millis(parsePositive0IntOrDefault(TEMPLATES_READ_TIMEOUT, TEMPLATES_READ_TIMEOUT_DEFAULT));
  }

}
