/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.analytics;

public interface GatewayAnalytics {

  String GW_ANALYTICS_REGISTRY_KEY = "gateway-analytics";

  /**
   * Whether the specified flow is generating Analytics event each time it is executed or not. The status can change during
   * runtime so it should be checked each time the flow is executed.
   * 
   * @param appName name of the application owner of the flow
   * @param flowName the flow processing the Mule Event
   * @return {@link AnalyticsStatus} of the {@link AnalyticsHttpEvent} generation for the specified flow
   */
  AnalyticsStatus status(String appName, String flowName);

}
