/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.client;

import static java.util.Objects.requireNonNull;

import com.mulesoft.mule.runtime.gw.api.construction.Builder;
import com.mulesoft.mule.runtime.gw.internal.client.ValidClient;

import java.io.Serializable;

/**
 * Defines a Client
 */
public abstract class Client implements Serializable {

  public static final String ASTERISKS = "******";
  private static final long serialVersionUID = -7969389139990798368L;

  public abstract String id();

  public abstract String secret();

  public abstract String name();

  @Override
  public String toString() {
    return "Client{" +
        "id='" + obfuscate(id()) + '\'' +
        ", secret=" + ASTERISKS + "";
  }

  private String obfuscate(String string) {
    if (string == null) {
      return "null";
    }
    int substringLength = (int) (string.length() * 0.15);

    return string.substring(0, substringLength) + ASTERISKS;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof Client)) {
      return false;
    }

    Client client = (Client) o;

    if (!id().equals(client.id())) {
      return false;
    }
    return secret().equals(client.secret());

  }

  @Override
  public int hashCode() {
    int result = id().hashCode();
    result = 31 * result + secret().hashCode();
    return result;
  }

  public static ClientBuilder builder() {
    return new ClientBuilder();
  }

  public static class ClientBuilder implements Builder<Client> {

    private String id;
    private String secret;
    private String name;

    public ClientBuilder withId(String id) {
      this.id = id;
      return this;
    }

    public ClientBuilder withSecret(String secret) {
      this.secret = secret;
      return this;
    }

    public ClientBuilder withName(String name) {
      this.name = name;
      return this;
    }

    @Override
    public Client build() {
      requireNonNull(id, "Cannot create a Client without its ID");
      requireNonNull(secret, "Cannot create a Client without its Secret");
      return new ValidClient(id, secret, name);
    }
  }
}
