/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.config;

public class ThrottlingConfiguration extends RuntimeConfiguration {

  /**
   * This flag enables or disables persistence of the throttling quota. Default is true.
   */
  private static final String PERSIST_THROTTLING_DATA = "throttling.persistence_enabled";
  private static final String PERSIST_THROTTLING_DATA_DEFAULT = "true";

  /**
   * Time elapsed between each dump of the throttling quota state to disk. Time is expressed in seconds. Default is 10.
   */
  private static final String THROTTLING_PERSISTENT_DATA_FREQ = "throttling.persistent_data_update_freq";
  private static final int THROTTLING_PERSISTENT_DATA_FREQ_DEFAULT = 10;

  ThrottlingConfiguration() {}

  public boolean shouldPersist() {
    return Boolean.valueOf(System.getProperty(PERSIST_THROTTLING_DATA, PERSIST_THROTTLING_DATA_DEFAULT).trim());
  }

  public int frequency() {
    return parseIntOrDefault(THROTTLING_PERSISTENT_DATA_FREQ, THROTTLING_PERSISTENT_DATA_FREQ_DEFAULT);
  }

}
