/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.contract;

import com.mulesoft.mule.runtime.gw.api.contract.tier.CompositeTier;
import com.mulesoft.mule.runtime.gw.api.contract.tier.Tier;

import java.util.List;

/**
 * TODO AGW-1169 Provide builders for all object in Gateway API Defines an SLA, represented by a Collection of Tiers.
 */
public class Sla extends CompositeTier {

  private static final long serialVersionUID = -8363362238115564011L;
  protected final Integer id;

  public Sla(Integer id, Tier... tiers) {
    super(tiers);
    this.id = id;
  }

  public Sla(Integer id, List<Tier> tiers) {
    super(tiers);
    this.id = id;
  }

  public Integer id() {
    return id;
  }

  @Override
  public String toString() {
    return "Sla{" +
        "id='" + id + '\'' +
        ", super=" + super.toString() +
        '}';
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof Sla)) {
      return false;
    }
    if (!super.equals(o)) {
      return false;
    }

    Sla sla = (Sla) o;

    return id.equals(sla.id);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode();
    result = 31 * result + id.hashCode();
    return result;
  }
}
