/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.contract.tier;

import static java.util.Arrays.asList;

import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Parameter;

import com.mulesoft.mule.runtime.gw.api.time.period.Period;

import java.io.Serializable;
import java.util.List;

/**
 * Defines a one level Tier
 */
@Alias("tier")
public class SingleTier implements Tier, Serializable {

  private static final long serialVersionUID = 3180085812900378840L;

  @Parameter
  private Integer maximumRequestsPerPeriod;

  @Parameter
  private Long timePeriodMillis;

  public SingleTier() {}

  public SingleTier(Integer maximumRequestsPerPeriod, Long timePeriodMillis) {
    this.maximumRequestsPerPeriod = maximumRequestsPerPeriod;
    this.timePeriodMillis = timePeriodMillis;
  }

  /**
   * @return the window length define by this tier.
   */
  public Period period() {
    return Period.millis(timePeriodMillis);
  }

  /**
   * @return the amount of requests per window.
   */
  public long requests() {
    return maximumRequestsPerPeriod;
  }

  @Override
  public List<SingleTier> flattened() {
    return asList(this);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SingleTier)) {
      return false;
    }

    SingleTier tier = (SingleTier) o;

    if (!maximumRequestsPerPeriod.equals(tier.maximumRequestsPerPeriod)) {
      return false;
    }
    return timePeriodMillis.equals(tier.timePeriodMillis);

  }

  @Override
  public int hashCode() {
    int result = maximumRequestsPerPeriod.hashCode();
    result = 31 * result + timePeriodMillis.hashCode();
    return result;
  }

  @Override
  public String toString() {
    return "SingleTier{" +
        "maximumRequestsPerPeriod=" + maximumRequestsPerPeriod +
        ", timePeriodMillis=" + timePeriodMillis +
        '}';
  }
}
