/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.key;

import static java.lang.String.format;

import com.mulesoft.mule.runtime.gw.api.contract.InvalidAPIException;

import java.io.Serializable;

/**
 * TODO AGW-1169 Provide builders for all object in Gateway API Defines an ApiKey, which is the only way to identify an API
 */
public class ApiKey implements Serializable {

  private static final long serialVersionUID = 9004939690145579516L;
  private final Long id;

  public ApiKey(Long id) {
    checkValid(id, "id");
    this.id = id;
  }

  public Long id() {
    return id;
  }

  @Override
  public String toString() {
    return "ApiKey{id='" + id + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    ApiKey apiKey = (ApiKey) o;

    return id != null ? id.equals(apiKey.id) : apiKey.id == null;
  }

  @Override
  public int hashCode() {
    return id != null ? id.hashCode() : 0;
  }

  private void checkValid(Long keyParameter, String description) {
    if (keyParameter == null) {
      throw new InvalidAPIException(format("Api %s cannot be null", description));
    }
  }
}
