/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.internal.encryption;

import static com.mulesoft.mule.runtime.gw.internal.encryption.RuntimeEncrypterFactory.createDefaultRuntimeEncrypter;

/**
 * Factory to create {@link ConfigurationPropertyEncrypter} instances
 */
public class ConfigurationPropertyEncryptionFactory {

  private ConfigurationPropertyEncryptionFactory() {}

  /**
   * Creates an encrypter to handle GW sensitive properties from configuration
   */
  public static ConfigurationPropertyEncrypter createConfigurationPropertyEncrypter() {
    return new ConfigurationPropertyEncrypter(createDefaultRuntimeEncrypter());
  }

}
