/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.internal.encryption;

import static java.util.Base64.getDecoder;
import static java.util.Base64.getEncoder;

import org.mule.encryption.Encrypter;
import org.mule.encryption.exception.MuleEncryptionException;

/**
 * Default implementation of {@link RuntimeEncrypter}
 */
public class DefaultRuntimeEncrypter extends RuntimeEncrypter {

  private Encrypter encrypter;

  public DefaultRuntimeEncrypter(Encrypter encrypter) {
    this.encrypter = encrypter;
  }

  @Override
  public String encrypt(String valueToEncrypt) throws GatewayEncryptionException {
    if (valueToEncrypt == null || containsEncryptionExpression(valueToEncrypt)) {
      return valueToEncrypt;
    }

    try {
      byte[] contentBytes = valueToEncrypt.getBytes();
      byte[] encryptedValue = encrypter.encrypt(contentBytes);

      return String.format("%s%s%s", PREFIX, new String(getEncoder().encode(encryptedValue)), SUFFIX);
    } catch (MuleEncryptionException e) {
      throw new GatewayEncryptionException("Error trying to encrypt one of the properties", e);
    }
  }

  @Override
  public String decrypt(String valueToDecrypt) throws GatewayEncryptionException {
    if (valueToDecrypt == null || !containsEncryptionExpression(valueToDecrypt)) {
      return valueToDecrypt;
    }

    try {
      byte[] contentBytes = extractValueFromExpression(valueToDecrypt).getBytes();
      byte[] content = getDecoder().decode(contentBytes);

      return new String(encrypter.decrypt(content));
    } catch (MuleEncryptionException e) {
      throw new GatewayEncryptionException("Error trying to decrypt " + valueToDecrypt, e);
    }
  }

}
