/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.internal.encryption;

/**
 * Defines a way to encrypt sensitive information
 */
public abstract class RuntimeEncrypter {

  public static final String PREFIX = "![";
  public static final String SUFFIX = "]";

  /**
   * Encrypts a single value.
   *
   * @param valueToEncrypt The value that should be encrypted
   * @return The encrypted value
   * @throws GatewayEncryptionException When there was an error while trying to encrypt
   */
  public abstract String encrypt(String valueToEncrypt) throws GatewayEncryptionException;

  /**
   * Decrypts a single value
   *
   * @param valueToDecrypt The value that should be decrypted
   * @return The decrypted value
   * @throws GatewayEncryptionException When there was an error while trying to decrypt
   */
  public abstract String decrypt(String valueToDecrypt) throws GatewayEncryptionException;

  /**
   * Checks if the string contains the encryption suffix and prefix, indicating that the value is already encrypted
   *
   * @param value The value to check
   * @return true if the value contains the encryption expression
   */
  protected boolean containsEncryptionExpression(String value) {
    return value != null && value.startsWith(PREFIX) && value.endsWith(SUFFIX);
  }

  protected String extractValueFromExpression(String value) {
    return value.substring(2, value.length() - 1);
  }
}
