/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.internal.expirable;

import com.mulesoft.mule.runtime.gw.api.expirable.Expirable;
import com.mulesoft.mule.runtime.gw.api.expirable.ExpirableObjectFactory;
import com.mulesoft.mule.runtime.gw.api.time.frame.TimeFrameFactory;
import com.mulesoft.mule.runtime.gw.api.time.period.Period;

import java.io.Serializable;

/**
 * Creates {@link TimeExpirable} object of type {@link T}.
 */
public class TimeExpirableObjectFactory<T extends Serializable> implements ExpirableObjectFactory<T> {

  private final TimeFrameFactory timeFrameFactory;
  private final Period period;

  public TimeExpirableObjectFactory(TimeFrameFactory timeFrameFactory, Period expirationPeriod) {
    this.timeFrameFactory = timeFrameFactory;
    this.period = expirationPeriod;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Expirable<T> create(T value) {
    return new TimeExpirable(value, timeFrameFactory.createCurrentWith(period));
  }
}
