/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw;

import static org.junit.Assert.assertEquals;

import org.junit.Test;
import com.mulesoft.mule.runtime.gw.api.contract.tier.SingleTier;
import com.mulesoft.mule.runtime.gw.api.contract.tier.CompositeTier;


public class CompositeTierTestCase {

  @Test
  public void singleTierWrapped() {
    SingleTier singleTier = new SingleTier(1, 2L);
    CompositeTier compositeTier = new CompositeTier(singleTier);

    assertEquals("Size should be 1", 1, compositeTier.flattened().stream().count());
    assertEquals(singleTier, compositeTier.flattened().stream().findFirst().get());
  }

  @Test
  public void singleTiersWrapped() {
    SingleTier tier1 = new SingleTier(1, 2L);
    SingleTier tier2 = new SingleTier(1, 123L);
    CompositeTier compositeTier = new CompositeTier(tier1, tier2);

    assertEquals("Size should be 2", 2, compositeTier.flattened().stream().count());
    assertEquals("Tier 1 not found", tier1, compositeTier.flattened().toArray()[0]);
    assertEquals("Tier 2 not found", tier2, compositeTier.flattened().toArray()[1]);
  }

  @Test
  public void oneLevelNestedComposites() {
    SingleTier tier1 = new SingleTier(1, 2L);
    SingleTier tier2 = new SingleTier(1, 123L);
    SingleTier tier3 = new SingleTier(1, 123123L);
    CompositeTier nestedComposite = new CompositeTier(tier1, tier2);
    CompositeTier compositeTier = new CompositeTier(nestedComposite, tier3);

    assertEquals("Size should be 3", 3, compositeTier.flattened().stream().count());
    assertEquals("Tier 1 not found", tier1, compositeTier.flattened().toArray()[0]);
    assertEquals("Tier 2 not found", tier2, compositeTier.flattened().toArray()[1]);
    assertEquals("Tier 3 not found", tier3, compositeTier.flattened().toArray()[2]);
  }

  @Test
  public void severalLevelsNestedComposites() {
    SingleTier tier1 = new SingleTier(1, 2L);
    SingleTier tier2 = new SingleTier(1, 123L);
    SingleTier tier3 = new SingleTier(1, 123123L);
    SingleTier tier4 = new SingleTier(1, 1663L);
    SingleTier tier5 = new SingleTier(1, 166443L);
    CompositeTier nestedComposite1 = new CompositeTier(tier1, tier2);
    CompositeTier nestedComposite3 = new CompositeTier(tier5);
    CompositeTier nestedComposite2 = new CompositeTier(tier4, nestedComposite3);
    CompositeTier compositeTier = new CompositeTier(nestedComposite1, tier3, nestedComposite2);

    assertEquals("Size should be 5", 5, compositeTier.flattened().stream().count());
    assertEquals("Tier 1 not found", tier1, compositeTier.flattened().toArray()[0]);
    assertEquals("Tier 2 not found", tier2, compositeTier.flattened().toArray()[1]);
    assertEquals("Tier 3 not found", tier3, compositeTier.flattened().toArray()[2]);
    assertEquals("Tier 4 not found", tier4, compositeTier.flattened().toArray()[3]);
    assertEquals("Tier 5 not found", tier5, compositeTier.flattened().toArray()[4]);
  }
}
