/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.config;

import static java.lang.System.setProperty;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;
import static org.mockito.Mockito.when;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(MockitoJUnitRunner.class)
public class OnApiDeletedConfigurationTestCase {

  @Mock
  private GateKeeperConfiguration gateKeeperConfiguration;

  private OnApiDeletedConfiguration configuration;

  @Before
  public void setUp() {
    configuration = new OnApiDeletedConfiguration(gateKeeperConfiguration);
  }

  @After
  public void tearDown() {
    System.clearProperty("anypoint.platform.policies.on_api_deleted");
  }

  @Test
  public void onApiDeletedDefault() {
    when(gateKeeperConfiguration.isEnabled()).thenReturn(true);

    assertThat(configuration.shouldBlock(), is(false));
  }

  @Test
  public void onApiDeletedKeepWhenGKDisabled() {
    when(gateKeeperConfiguration.isEnabled()).thenReturn(false);

    assertThat(configuration.shouldBlock(), is(false));
  }

  @Test
  public void onApiDeletedBlockWhenGKEnabled() {
    when(gateKeeperConfiguration.isEnabled()).thenReturn(true);

    setProperty("anypoint.platform.policies.on_api_deleted", "block_api");
    assertThat(configuration.shouldBlock(), is(true));
  }

  @Test
  public void onApiDeletedBlockWhenGKDisabled() {
    when(gateKeeperConfiguration.isEnabled()).thenReturn(false);

    setProperty("anypoint.platform.policies.on_api_deleted", "block_api");
    assertThat(configuration.shouldBlock(), is(false));
  }

  @Test
  public void onApiDeletedCaseInsensitive() {
    when(gateKeeperConfiguration.isEnabled()).thenReturn(true);

    setProperty("anypoint.platform.policies.on_api_deleted", "bloCK_aPi");
    assertThat(configuration.shouldBlock(), is(true));
  }

  @Test
  public void onApiDeletedInvalid() {
    setProperty("anypoint.platform.policies.on_api_deleted", "alpha");
    assertThat(configuration.shouldBlock(), is(false));
  }
}
