/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.analytics;

import java.io.Serializable;

public class AnalyticsHttpEvent implements Serializable {

  private static final long serialVersionUID = 4895617753262565224L;

  /**
   * Platform's v3 API replaced API unique identifier with a new one, but this id is still expected by analytics API.
   */
  private Integer apiId;

  /**
   * Unique identifier of the API.
   */
  private Long apiVersionId;

  /**
   * API's organization identifier.
   */
  private String orgId;

  /**
   * Host identifier where the API is running.
   */
  private String hostId;

  /**
   * Client's identifier who made the HTTP request.
   */
  private String clientId;

  /**
   * Transaction identifier of the Mule's event.
   */
  private String transactionId;

  /**
   * Time when the HTTP request was received formatted following ISO8601 standard.
   */
  private String receivedTs;

  /**
   * Time when the HTTP request was replied formatted following ISO8601 standard.
   */
  private String repliedTs;

  /**
   * IP of the client who made the HTTP request.
   */
  private String clientIp;

  /**
   * HTTP Method of the request.
   */
  private String verb;

  /**
   * Path of the request.
   */
  private String path;

  /**
   * HTTP status code of the HTTP response.
   */
  private int statusCode;

  /**
   * HTTP user agent that made the request.
   */
  private String userAgent;

  /**
   * Size of the HTTP request's payload in bytes.
   */
  private int requestBytes;

  /**
   * Size of the HTTP response's payload in bytes.
   */
  private int responseBytes;

  /**
   * {@link RequestDisposition} of the HTTP request.
   */
  private RequestDisposition requestDisposition;

  /**
   * {@link PolicyViolation}, if any after the HTTP request was processed.
   */
  private PolicyViolation policyViolation;

  /**
   * API's name as defined by API Platform.
   */
  private String apiName;

  /**
   * API's version name as defined by API Platform.
   */
  private String apiVersion;

  /**
   * API's instance name as defined by API Platform.
   */
  private String instanceName;

  /**
   * Client's name who made the HTTP request.
   */
  private String applicationName;

  /**
   * Mule's event identifier.
   */
  private String eventId;

  /**
   * Name of the flow that originated the event.
   */
  private String flowName;

  /**
   * Name of the Mule Application that originated the event.
   */
  private String muleAppName;

  /**
   * Mule's deployment type.
   */
  private DeploymentType deploymentType;

  private AnalyticsHttpEvent() {}

  public static Builder builder() {
    return new Builder();
  }

  public Integer getApiId() {
    return apiId;
  }

  public Long getApiVersionId() {
    return apiVersionId;
  }

  public String getOrgId() {
    return orgId;
  }

  public String getHostId() {
    return hostId;
  }

  public String getClientId() {
    return clientId;
  }

  public String getTransactionId() {
    return transactionId;
  }

  public String getReceivedTs() {
    return receivedTs;
  }

  public String getRepliedTs() {
    return repliedTs;
  }

  public String getClientIp() {
    return clientIp;
  }

  public String getVerb() {
    return verb;
  }

  public String getPath() {
    return path;
  }

  public int getStatusCode() {
    return statusCode;
  }

  public String getUserAgent() {
    return userAgent;
  }

  public int getRequestBytes() {
    return requestBytes;
  }

  public int getResponseBytes() {
    return responseBytes;
  }

  public RequestDisposition getRequestDisposition() {
    return requestDisposition;
  }

  public PolicyViolation getPolicyViolation() {
    return policyViolation;
  }

  public String getApiName() {
    return apiName;
  }

  public String getApiVersion() {
    return apiVersion;
  }

  public String getApplicationName() {
    return applicationName;
  }

  public String getEventId() {
    return eventId;
  }

  public String getInstanceName() {
    return instanceName;
  }

  public String getFlowName() {
    return flowName;
  }

  public String getMuleAppName() {
    return muleAppName;
  }

  public DeploymentType getDeploymentType() {
    return deploymentType;
  }

  public String toString() {
    return "HttpEvent #" + hashCode() + "{" +
        "apiName=" + apiName +
        ", apiVersion=" + apiVersion +
        ", instanceName=" + instanceName +
        ", orgId='" + orgId + '\'' +
        ", hostId='" + hostId + '\'' +
        ", clientId='" + clientId + '\'' +
        ", applicationName='" + applicationName + '\'' +
        ", transactionId='" + transactionId + '\'' +
        ", receivedTs='" + receivedTs + '\'' +
        ", repliedTs='" + repliedTs + '\'' +
        ", clientIp='" + clientIp + '\'' +
        ", verb='" + verb + '\'' +
        ", path='" + path + '\'' +
        ", statusCode=" + statusCode +
        ", userAgent='" + userAgent + '\'' +
        ", requestBytes=" + requestBytes +
        ", responseBytes=" + responseBytes +
        ", requestDisposition=" + requestDisposition +
        ", policyViolation=" + policyViolation +
        ", eventId=" + eventId +
        ", muleAppName=" + muleAppName +
        ", flowName=" + flowName +
        ", deploymentType=" + deploymentType +
        '}';
  }

  public static class Builder {

    private final AnalyticsHttpEvent event;

    public Builder() {
      this.event = new AnalyticsHttpEvent();
    }

    public Builder withApiId(Integer apiId) {
      event.apiId = apiId;
      return this;
    }

    public Builder withApiVersionId(Long apiVersionId) {
      event.apiVersionId = apiVersionId;
      return this;
    }

    public Builder withOrgId(String orgId) {
      event.orgId = orgId;
      return this;
    }

    public Builder withHostId(String hostId) {
      event.hostId = hostId;
      return this;
    }

    public Builder withClientId(String clientId) {
      event.clientId = clientId;
      return this;
    }

    public Builder withTransactionId(String transactionId) {
      event.transactionId = transactionId;
      return this;
    }

    public Builder withReceivedTs(String receivedTs) {
      event.receivedTs = receivedTs;
      return this;
    }

    public Builder withRepliedTs(String repliedTs) {
      event.repliedTs = repliedTs;
      return this;
    }

    public Builder withClientIp(String clientIp) {
      event.clientIp = clientIp;
      return this;
    }

    public Builder withVerb(String verb) {
      event.verb = verb;
      return this;
    }

    public Builder withPath(String path) {
      event.path = path;
      return this;
    }

    public Builder withStatusCode(int statusCode) {
      event.statusCode = statusCode;
      return this;
    }

    public Builder withUserAgent(String userAgent) {
      event.userAgent = userAgent;
      return this;
    }

    public Builder withRequestBytes(int requestBytes) {
      event.requestBytes = requestBytes;
      return this;
    }

    public Builder withResponseBytes(int responseBytes) {
      event.responseBytes = responseBytes;
      return this;
    }

    public Builder withRequestDisposition(RequestDisposition requestDisposition) {
      event.requestDisposition = requestDisposition;
      return this;
    }

    public Builder withPolicyViolation(PolicyViolation policyViolation) {
      event.policyViolation = policyViolation;
      return this;
    }

    public Builder withApiName(String apiName) {
      event.apiName = apiName;
      return this;
    }

    public Builder withApiVersion(String apiVersion) {
      event.apiVersion = apiVersion;
      return this;
    }

    public Builder withInstanceName(String instanceName) {
      event.instanceName = instanceName;
      return this;
    }

    public Builder withApplicationName(String applicationName) {
      event.applicationName = applicationName;
      return this;
    }

    public Builder withEventId(String eventId) {
      event.eventId = eventId;
      return this;
    }

    public Builder withFlowName(String flowName) {
      event.flowName = flowName;
      return this;
    }

    public Builder withMuleAppName(String muleAppName) {
      event.muleAppName = muleAppName;
      return this;
    }

    public void withDeploymentType(DeploymentType deploymentType) {
      event.deploymentType = deploymentType;
    }

    public AnalyticsHttpEvent build() {
      return event;
    }
  }

}
