/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.client;

import static java.util.Objects.requireNonNull;

import com.mulesoft.mule.runtime.gw.api.construction.Builder;
import com.mulesoft.mule.runtime.gw.internal.client.ValidCoreServicesClient;

import java.util.Set;

public abstract class CoreServicesClient extends Client {

  private static final long serialVersionUID = -6715117168971723346L;

  public abstract Set<String> redirectionUris();


  public static ClientBuilder getBuilder() {
    return new ClientBuilder();
  }

  public static class ClientBuilder implements Builder<CoreServicesClient> {

    private String id;
    private String secret;
    private String name;
    private Set<String> redirectionUris;

    public ClientBuilder withId(String id) {
      this.id = id;
      return this;
    }

    public ClientBuilder withSecret(String secret) {
      this.secret = secret;
      return this;
    }

    public ClientBuilder withName(String name) {
      this.name = name;
      return this;
    }

    public ClientBuilder withRedirectionUris(Set<String> redirectionUris) {
      this.redirectionUris = redirectionUris;

      return this;
    }

    @Override
    public CoreServicesClient build() {
      requireNonNull(id, "Cannot create a Client without its ID");
      requireNonNull(secret, "Cannot create a Client without its Secret");
      return new ValidCoreServicesClient(id, secret, name, redirectionUris);
    }
  }
}
