/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.config;

import static java.lang.Boolean.valueOf;
import static java.lang.System.getProperty;
import static org.apache.commons.lang3.StringUtils.trimToNull;

public class MetricsConfiguration extends RuntimeConfiguration {

  /**
   * Configure if the metrics functionality will be enabled or disabled
   */
  private static final String METRICS_ENABLED = "anypoint.platform.metrics_enabled";
  private static final String METRICS_ENABLED_DEFAULT = "true";

  /**
   * Amount of time elapsed (in seconds) until the next cycle of events will be pushed.
   */
  private static final String METRICS_PUSH_FREQUENCY = "anypoint.platform.metrics_push_freq";
  private static final int METRICS_PUSH_FREQUENCY_DEFAULT = 600; // 10 min.

  /**
   * Amount of time (in seconds) between the periodic 'status' event is generated. This value may not represent the real
   * periodicity since the metrics configuration can be dynamically configured by the ingest endpoint.
   */
  private static final String METRICS_STATUS_FREQUENCY = "anypoint.platform.metrics_status_freq";
  private static final int METRICS_STATUS_FREQUENCY_DEFAULT = 60 * 60 * 24; // 24 Hs

  /**
   * Cache capacity of the metrics events stored in memory until old ones are dropt.
   */
  private static final String METRICS_CAPACITY = "anypoint.platform.metrics_capacity";
  private static final int METRICS_CAPACITY_DEFAULT = 3000;

  public Boolean metricsEnabled() {
    return valueOf(trimToNull(getProperty(METRICS_ENABLED, METRICS_ENABLED_DEFAULT)));
  }

  public int getMetricsStatusFrequency() {
    return parseIntOrDefault(METRICS_STATUS_FREQUENCY, METRICS_STATUS_FREQUENCY_DEFAULT);
  }

  public int getMetricsCapacity() {
    return parseIntOrDefault(METRICS_CAPACITY, METRICS_CAPACITY_DEFAULT);
  }

  public int getMetricsPushEventsFrequency() {
    return parseIntOrDefault(METRICS_PUSH_FREQUENCY, METRICS_PUSH_FREQUENCY_DEFAULT);
  }
}
