/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.config;

public class ProxyConfiguration extends RuntimeConfiguration {

  /**
   * Allows generation of X-Forwarded-For and X-Forwarded-Host headers. Default is true.
   */
  private static final String X_FORWARDED_HEADERS_PROPAGATION = "anypoint.platform.x_forwarded_headers_propagation";
  private static final String DEFAULT_X_FORWARDED_HEADERS_PROPAGATION = "true";

  ProxyConfiguration() {}

  public boolean propagateXForwardedHeaders() {
    return Boolean
        .valueOf(System.getProperty(X_FORWARDED_HEADERS_PROPAGATION, DEFAULT_X_FORWARDED_HEADERS_PROPAGATION).trim());
  }

}
