/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.contract;

import com.mulesoft.mule.runtime.gw.api.contract.tier.SingleTier;

/**
 * Null object pattern of an SLA
 */
public class NoSla extends Sla {

  private static final Long TEN_YEARS = 315360000000L;
  private static final long serialVersionUID = 8228749590867956503L;

  public NoSla() {
    /**
     * The 10 years period is because if we use Long.maxValue, it will raise an overflow when calculating next window. If there is
     * no SLA define for a client, once every 10 years, it will reset that time frame.
     */
    super(0, new SingleTier(0, TEN_YEARS));
  }
}
