/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.contract.tier;

import static com.google.common.collect.Lists.newArrayList;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

/**
 * Defines a Composite of tiers, all of which can also be composites, creating a tree like structure.
 */
public class CompositeTier implements Tier, Serializable {

  private static final long serialVersionUID = -7517192138560153981L;
  private final List<Tier> tiers;

  public CompositeTier(Tier... tiers) {
    this.tiers = newArrayList(tiers);
  }

  public CompositeTier(List<Tier> tiers) {
    this.tiers = newArrayList(tiers);
  }

  @Override
  public List<SingleTier> flattened() {
    return tiers
        .stream()
        .map(tier -> tier.flattened())
        .flatMap(List::stream)
        .collect(Collectors.toList());
  }

  private boolean tiersIn(List<Tier> anotherTiers) {
    return this.tiers.stream().allMatch(tier -> anotherTiers.contains(tier));
  }

  @Override
  public int hashCode() {
    return tiers != null ? tiers.hashCode() : 0;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CompositeTier)) {
      return false;
    }

    CompositeTier otherSLA = (CompositeTier) o;

    return this.tiersIn(otherSLA.tiers) &&
        otherSLA.tiersIn(this.tiers);
  }

  @Override
  public String toString() {
    return "CompositeTier{" +
        "tiers=" + tiers.stream()
            .map(tier -> tier.toString())
            .reduce("", (appendedTiers, lastTier) -> lastTier + ", " + appendedTiers)
        + '}';
  }
}
