/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.security;

import static java.util.Collections.emptyMap;
import static java.util.Collections.unmodifiableMap;

import org.mule.runtime.api.security.Authentication;

import java.util.HashMap;
import java.util.Map;

public class ClientAuthentication implements Authentication {

  private static final long serialVersionUID = -4279495927486298514L;
  private final String clientId;
  private final String clientSecret;
  private final Map<String, Object> properties;

  public ClientAuthentication(String clientId, String clientSecret, Map<String, Object> properties) {
    this.clientId = clientId;
    this.clientSecret = clientSecret;
    this.properties = properties != null ? unmodifiableMap(properties) : emptyMap();
  }

  @Override
  public String getCredentials() {
    return this.clientSecret;
  }

  @Override
  public String getPrincipal() {
    return this.clientId;
  }

  @Override
  public Map<String, Object> getProperties() {
    return this.properties;
  }

  @Override
  public ClientAuthentication setProperties(Map<String, Object> properties) {
    Map<String, Object> newProperties = new HashMap<>(this.properties);
    newProperties.putAll(properties);
    return new ClientAuthentication(this.clientId, this.clientSecret, newProperties);
  }

}
