/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright law. All use of this software is subject to
 * MuleSoft's Master Subscription Agreement (or other Terms of Service) separately entered into between you and MuleSoft. If such an
 * agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.gw.api.time;

import java.io.Serializable;

public class DateTime implements Serializable {

  private static final long serialVersionUID = -7393883664563328127L;
  private final org.joda.time.DateTime dateTime;

  public DateTime(long instant) {
    this.dateTime = new org.joda.time.DateTime(instant);
  }

  public static DateTime now() {
    return new DateTime(org.joda.time.DateTime.now().getMillis());
  }

  public DateTime plus(long duration) {
    return new DateTime(dateTime.plus(duration).getMillis());
  }

  public long getMillis() {
    return dateTime.getMillis();
  }

  public DateTime plusMillis(int millis) {
    return new DateTime(dateTime.plusMillis(millis).getMillis());
  }

  public boolean isAfter(DateTime instant) {
    return dateTime.isAfter(instant.getMillis());
  }

  public boolean isBefore(DateTime instant) {
    return dateTime.isBefore(instant.getMillis());
  }

  public DateTime minus(long duration) {
    return new DateTime(dateTime.minus(duration).getMillis());
  }

  public DateTime plusDays(int days) {
    return new DateTime(dateTime.plusDays(days).getMillis());
  }

  public DateTime plusMinutes(int minutes) {
    return new DateTime(dateTime.plusMinutes(minutes).getMillis());
  }

  public DateTime minusHours(int hours) {
    return new DateTime(dateTime.minusHours(hours).getMillis());
  }

  public DateTime minusMinutes(int minutes) {
    return new DateTime(dateTime.minusMinutes(minutes).getMillis());
  }

  @Override
  public String toString() {
    return "DateTime{" + dateTime + '}';
  }

  @Override
  public boolean equals(Object o) {
    if (this == o)
      return true;
    if (!(o instanceof DateTime))
      return false;

    DateTime dateTime1 = (DateTime) o;

    return dateTime.equals(dateTime1.dateTime);
  }

  @Override
  public int hashCode() {
    return dateTime.hashCode();
  }
}
